package com.wecloud.im.param.app;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * APP用户
 *
 * @author wei
 * @since 2020-09-23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppUserInfoParam对象")
public class AppUserInfoParam extends BaseEntity {

    @ApiModelProperty("用户姓名")
    private String username;

    @ApiModelProperty("微信id")
    private String wechatOpenId;

    @ApiModelProperty("微信昵称")
    private String nickname;

    @ApiModelProperty("证件号码")
    private String idcard;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("手机区号")
    private String phoneArea;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("头像")
    private String head;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态，0：禁用，1：启用，2：锁定")
    private Integer state;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

    @ApiModelProperty("文化程度")
    private String educationBackground;

    @ApiModelProperty("邮件")
    private String email;

    @ApiModelProperty("省市区")
    private String location;

    @ApiModelProperty("详细地址")
    private String locationDetail;

    @ApiModelProperty("职业")
    private String profession;

    @ApiModelProperty("工作单位")
    private String company;

    @ApiModelProperty("紧急电话")
    private String emergencyPhone;

}
