package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 系统用户
 *
 * @author hewei
 * @since 2021-02-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppUser对象")
public class AppUser extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("用户名")
    private String username;

    @ApiModelProperty("微信id")
    private String wechatOpenId;

    @ApiModelProperty("姓名")
    private String nickname;

    @ApiModelProperty("证件号码")
    private String idcard;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("盐值")
    private String salt;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("手机区号")
    private String phoneArea;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("头像")
    private String head;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态，0：禁用，1：启用，2：锁定")
    private Integer state;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty("版本")
    @Version
    private Integer version;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

    @ApiModelProperty("文化程度")
    private String educationBackground;

    @ApiModelProperty("邮件")
    private String email;

    @ApiModelProperty("省市区")
    private String location;

    @ApiModelProperty("详细地址")
    private String locationDetail;

    @ApiModelProperty("职业")
    private String profession;

    @ApiModelProperty("工作单位")
    private String company;

    @ApiModelProperty("紧急电话")
    private String emergencyPhone;

}
