package com.jumeirah.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 商家飞机表
 *
 * @author xxx
 * @since 2020-10-19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "McPlain对象")
public class McPlain extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "飞机类型ID不能为空")
    @ApiModelProperty("飞机类型ID")
    private Long ptId;

    @NotNull(message = "状态，0-正常，1-禁用，99-删除不能为空")
    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @NotNull(message = "创建时间（时间戳）不能为空")
    @ApiModelProperty("创建时间（时间戳）")
    private Long createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Long updateTime;

    @NotNull(message = "商家ID不能为空")
    @ApiModelProperty("商家ID")
    private Long mcId;

    @NotNull(message = "数量不能为空")
    @ApiModelProperty("数量")
    private Integer amount;

    @NotNull(message = "所在地城市ID不能为空")
    @ApiModelProperty("所在地城市ID")
    private Long cityId;

}
