package com.wecloud.im.service;

import com.wecloud.im.param.SyncListMessageParam;
import com.wecloud.im.param.WeCloudMessageVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ChatContentVo;
import com.wecloud.im.param.GetReadersParam;
import com.wecloud.im.param.GroupChatMessageParam;
import com.wecloud.im.param.GroupChatStatusMessageParam;
import com.wecloud.im.param.ImClientSimpleDto;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.MsgDeleteParam;
import com.wecloud.im.param.PrivateChatMessageParam;
import com.wecloud.im.param.PrivateChatStatusMessageParam;
import com.wecloud.im.param.SingleUserNotificationParam;
import com.wecloud.im.param.add.ImMsgRecall;
import com.wecloud.im.param.add.ImMsgSendToOnlineClient;
import com.wecloud.im.param.add.ImMsgUpdate;
import com.wecloud.im.vo.ImMessageOfflineListVo;
import com.wecloud.im.vo.OfflineMsgDto;
import com.wecloud.im.vo.ReaderList;
import com.wecloud.im.ws.model.request.ReceiveDataVO;
import com.wecloud.im.ws.model.request.ReceiveVO;

/**
 * 消息存储表 服务类
 *
 * @author wei
 * @since 2021-04-29
 */
public interface ImMessageService extends BaseService<ImMessage> {


    /**
     * 下发透传消息
     *
     * @param imMsgSendToOnlineClient
     * @return
     */
    ApiResult<Boolean> restApiImMessageSend(ImMsgSendToOnlineClient imMsgSendToOnlineClient, ImApplication imApplication);

    @Transactional(rollbackFor = Exception.class)
    ImMessage saveImMessage(ImClientSimpleDto client, ChatContentVo data);

    /**
     * 消息撤回
     * @param imMsgRecall
     * @param request
     * @return
     */
    Boolean withdrawMsg(ImMsgRecall imMsgRecall);

    /**
     * 删除消息
     * @param param
     * @return
     */
    Boolean deleteMsg(MsgDeleteParam param);

    /**
     * 修改消息体
     *
     * @param imMsgUpdate
     * @return
     */
    Boolean updateMsgById(ImMsgUpdate imMsgUpdate);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationId(ImHistoryMessagePageParam param);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationIdNew(ImHistoryMessagePageParam param);

    /**
     * 查询用户所有离线消息
     *
     * @return
     * @throws Exception
     */
    List<ImMessageOfflineListVo> getOfflineList() throws Exception;

    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(Long clientId, Long conversationId);


    /**
     * 查询会话的最后一条消息
     *
     * @param conversationId
     * @return
     */
    OfflineMsgDto getLastMsgByConversationId(Long conversationId, Long currentFkClientId);

    /**
     * 查询会话接收的最后一条消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    OfflineMsgDto getReceivedLastMsgByConversationId(Long clientId, Long conversationId);

    /**
     * 获取读取人员
     * @param param
     * @return
     */
    ReaderList getReaders(GetReadersParam param);

    /**
     * 发送群聊消息
     * @param param
     * @return
     */
    Boolean groupMessagePublish(GroupChatMessageParam param);

    /**
     * 发送群聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 02:32:58
     * @param param
     * @Return
     */
    Boolean groupStatusMessagePublish(GroupChatStatusMessageParam param);

    /**
     * 发送单聊消息
     * @Author luozh
     * @Date 2022年05月05日 02:33:26
     * @param param
     * @Return
     */
    Boolean privateMessagePublish(PrivateChatMessageParam param);

    /**
     * 发送单聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 02:33:56
     * @param param
     * @Return
     */
    Boolean privateStatusMessagePublish(PrivateChatStatusMessageParam param);

    /**
     * 单个用户通知-普通消息
     * @Author luozh
     * @Date 2022年05月25日 10:42:31
     * @param param
     * @Return
     */
    Boolean singleUserNotification(SingleUserNotificationParam param);

    List<WeCloudMessageVo> syncListMessage(SyncListMessageParam param);

    /**
     * 保存消息到数据库
     * @param imMessage
     */
    void saveMessageToDb(ImMessage imMessage);

}
