package com.wecloud.im.sdk.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import com.wecloud.im.sdk.enums.GroupChatSettingTypeEnum;

/**
 * 群聊设置入参
 * @Author luozh
 * @Date 2022年04月27日 11:20
 * @Version 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GroupSettingRequest extends WebServiceRequest {

    /**
     * 设置类型 FORBID_ADD_FRIEND  禁止群成员互加好友
     *         FORBID_SEND_PIC    禁止群成员发图片
     *         FORBID_SEND_LINK   禁止群成员发链接
     *         MUTED              群禁言
     *         NAME               修改群名
     *         HEAD_PORTRAIT      修改头像
     */
    private GroupChatSettingTypeEnum type;

    /**
     * 群组id
     */
    private String groupId;

    /**
     * 开关状态
     */
    private Boolean on;

    /**
     * 群名称 修改群名称时传值
     */
    private String name;

    /**
     * 头像 修改群头像时传值
     */
    private String headPortrait;
}
