package io.geekidea.springbootplus.framework.shiro.util;

import io.geekidea.springbootplus.framework.shiro.signature.SignatureAuthToken;

/**
 *
 * @Author luozh
 * @Date 2022年04月15日 19:57
 * @Version 1.0
 */
public class SecurityUtils {

    /**
     * 获取当前签名token
     * @Author luozh
     * @Date 2022年04月15日 07:53:54
     * @param
     * @Return 签名token
     */
    public static SignatureAuthToken getCurrentSignatureAuthToken() {
        return (SignatureAuthToken) org.apache.shiro.SecurityUtils.getSubject().getPrincipal();
    }

    /**
     * 获取当前请求appId
     * @Author luozh
     * @Date 2022年04月15日 07:58:36
     * @param
     * @Return
     */
    public static Long getCurrentAppId() {
        return getCurrentSignatureAuthToken().getAppId();
    }

    /**
     * 获取当前请求appKey
     * @Author luozh
     * @Date 2022年04月15日 07:58:56
     * @param
     * @Return
     */
    public static String getCurrentAppKey() {
        return getCurrentSignatureAuthToken().getAppKey();
    }
}
