package com.wecloud.im.sdk.internal;

import java.net.URL;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.SingleUserNotificationRequest;

import static com.wecloud.im.sdk.ResourcePathConstants.SINGLE_USER_NOTIFICATION_REQUEST;
import static com.wecloud.im.sdk.utils.CodingUtils.assertParameterNotNull;

/**
 * 系统通知操作
 * @Author luozh
 * @Date 2022年05月10日 09:30
 * @Version 1.0
 */
public class WecloudImSystemNotificationOperation extends WecloudImOperation {

    public WecloudImSystemNotificationOperation(URL apiDomain, String appKey, String appSecret) {
        super(apiDomain, appKey, appSecret);
    }

    public Boolean singleUserNotification(SingleUserNotificationRequest singleUserNotificationRequest) {
        String fromUserId = singleUserNotificationRequest.getFromUserId();
        String toUserIds = singleUserNotificationRequest.getToUserIds();
        String messageType = singleUserNotificationRequest.getMessageType();
        String content = singleUserNotificationRequest.getContent();
        // 必填参数校验
        assertParameterNotNull(fromUserId, "fromUserId");
        assertParameterNotNull(toUserIds, "toUserIds");
        assertParameterNotNull(messageType, "messageType");
        assertParameterNotNull(content, "content");
        // 校验通过 构建参数
        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        Map<String, Object> param = JSONObject.parseObject(JSON.toJSONString(singleUserNotificationRequest), typeReference);
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(SINGLE_USER_NOTIFICATION_REQUEST)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(singleUserNotificationRequest).build();
        doOperation(request);
        return true;
    }
}
