package com.wecloud.im.sdk;

import lombok.experimental.UtilityClass;

/**
 * 资源常量类
 * @Author luozh
 * @Date 2022年04月18日 13:34
 * @Version 1.0
 */
@UtilityClass
public class ResourcePathConstants {

    /**
     * 注册客户端
     */
    public static final String REGISTER_CLIENT_URL = "/api/imClient/registerClient";

    /**
     * 获取token
     */
    public static final String GET_TOKEN_URL = "/api/token/getToken";

    /**
     * 修改用户
     */
    public static final String MODIFY_USER_URL = "/api/imClient/updateHeadAndNickname";

    /**
     * 获取好友申请列表
     */
    public static final String GET_UNSURE_FRIENDS = "/api/friend/sdk/unsureFriends";

    /**
     * 全量获取好友列表
     */
    public static final String GET_FRIENDS = "/api/friend/sdk/getFriends";

    /**
     * 群设置
     */
    public static final String CHAT_SETTING = "/api/imConversationMembers/chatSetting";

    /**
     * 好友请求
     */
    public static final String FRIEND_REQUEST = "/api/friend/sdk/apply";

    /**
     * 群成员互加好友
     */
    public static final String GROUP_MEMBERS_FRIEND_REQUEST = "/api/imConversationMembers/addUser";

    /**
     * 获取聊天室成员
     */
    public static final String LIST_CHAT_ROOM_MEMBER_REQUEST = "/api/conversation/listChatRoomMember";

    /**
     * 批量获取会话信息
     */
    public static final String LIST_CONVERSATION_REQUEST = "/api/conversation/listConversation";

    /**
     * 发布群消息
     */
    public static final String PUBLISH_GROUP_CHAT_MESSAGE_REQUEST = "/api/imMessage/group/publish";

    /**
     * 发布群状态消息
     */
    public static final String PUBLISH_GROUP_CHAT_STATUS_MESSAGE_REQUEST = "/api/imMessage/group/status/publish";

    /**
     * 发布群消息
     */
    public static final String PUBLISH_PRIVATE_CHAT_MESSAGE_REQUEST = "/api/imMessage/private/publish";

    /**
     * 发布群状态消息
     */
    public static final String PUBLISH_PRIVATE_CHAT_STATUS_MESSAGE_REQUEST = "/api/imMessage/private/status/publish";


}
