package com.ym.im.core;

import com.ym.im.entity.MsgBody;
import com.ym.im.util.JsonUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * 对象编码器
 * @Date:2019-05-17
 */
@Component
@ChannelHandler.Sharable
public class MessageEncoder extends MessageToByteEncoder<MsgBody> {

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, MsgBody msgBody, ByteBuf byteBuf) throws Exception {
        channelHandlerContext.writeAndFlush(new TextWebSocketFrame(JsonUtils.obj2Json(msgBody)));
    }
}
