package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.MerchantPermission;
import com.jumeirah.common.mapper.MerchantPermissionMapper;
import com.jumeirah.common.service.MerchantPermissionService;
    import com.jumeirah.common.param.MerchantPermissionPageParam;
    import com.jumeirah.common.vo.MerchantPermissionQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 商家权限 服务实现类
 *
 * @author wei
 * @since 2020-09-28
 */
@Slf4j
@Service
public class MerchantPermissionServiceImpl extends BaseServiceImpl<MerchantPermissionMapper, MerchantPermission> implements MerchantPermissionService {

@Autowired
private MerchantPermissionMapper merchantPermissionMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveMerchantPermission(MerchantPermission merchantPermission)throws Exception{
        return super.save(merchantPermission);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateMerchantPermission(MerchantPermission merchantPermission)throws Exception{
        return super.updateById(merchantPermission);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteMerchantPermission(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public MerchantPermissionQueryVo getMerchantPermissionById(Long id)throws Exception{
            return merchantPermissionMapper.getMerchantPermissionById(id);
            }

@Override
public Paging<MerchantPermissionQueryVo> getMerchantPermissionPageList(MerchantPermissionPageParam merchantPermissionPageParam)throws Exception{
        Page<MerchantPermissionQueryVo> page=new PageInfo<>(merchantPermissionPageParam,OrderItem.desc(getLambdaColumn(MerchantPermission::getCreateTime)));
            IPage<MerchantPermissionQueryVo> iPage= merchantPermissionMapper.getMerchantPermissionPageList(page, merchantPermissionPageParam);
        return new Paging<MerchantPermissionQueryVo>(iPage);
        }

        }
