package com.wecloud.im.sdk.model.message;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * 消息图片文件
 * @Author luozh
 * @Date 2022年05月07日 14:00
 * @Version 1.0
 */
@Data
public class MessageImageFile {


    /**
     * 图片地址
     */
    private String url;

    /**
     * 元数据
     */
    private MetaData metaData;

    @Setter
    @Getter
    public static class MetaData {
        /**
         * 图像的名称
         */
        private String name;

        /**
         * 图像的格式
         */
        private String format;

        /**
         * 高度(单位 像素)
         */
        private Integer height;

        /**
         * 宽度(单位 像素)
         */
        private Integer width;

        /**
         * 大小 单位b
         */
        private Integer size;
    }

}
