package com.wecloud.im.ws.strategy.concrete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientBlacklistService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.ws.annotation.CmdTypeAnnotation;
import com.wecloud.im.ws.enums.WsRequestCmdEnum;
import com.wecloud.im.ws.model.request.ReceiveModel;
import com.wecloud.im.ws.sender.SystemPush;
import com.wecloud.im.ws.service.WriteDataService;
import com.wecloud.im.ws.strategy.ImCmdAbstract;
import com.wecloud.rtc.RtcSubCmd;
import io.netty.channel.ChannelHandlerContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 处理RTC信令消息
 */
@CmdTypeAnnotation(type = WsRequestCmdEnum.SINGLE_RTC)
@Service
@Slf4j
public class SingleRtcConcrete extends ImCmdAbstract {


    private static final JsonMapper JSON_MAPPER = new JsonMapper();

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    @Autowired
    private WriteDataService writeDataService;

    @Autowired
    private ImMessageService imMessageService;

    @Autowired
    private ImInboxService imInboxService;

    @Autowired
    private ImApplicationService imApplicationService;

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private SystemPush systemPush;

    @Override
    public void process(ReceiveModel receiveModel, ChannelHandlerContext ctx, String data, String appKey, String clientId) throws JsonProcessingException {

        // 指令判空
        if (receiveModel.getData().get(RtcSubCmd.SUB_CMD) == null) {
            return;
        }

        String cmd = receiveModel.getData().get(RtcSubCmd.SUB_CMD).toString();
        switch (cmd) {
//            //创建频道
//            case RtcSubCmd.CREATE:
//                break;
//
//            //加入频道
//            case RtcSubCmd.JOIN:
//                break;
//
//            //拒绝加入频道
//            case RtcSubCmd.REJECT:
//                break;
//
//            //SDP数据转发
//            case RtcSubCmd.SDP:
//                break;
//
//            //主动挂断(离开频道)
//            case RtcSubCmd.LEAVE:
//                break;

        }

    }

}
