package com.wecloud.im.ws.enums;

/**
 * @Description ws响应类型
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public enum WsResponseCmdEnum {

    /**
     * 下发单人在线RTC事件
     */
    SINGLE_RTC_MSG(4),

    /**
     * 下发在线事件消息
     */
    ONLINE_EVENT_MSG(3),

    /**
     * 下发在线基本类型消息
     */
    ONLINE_MSG(2),

    /**
     * 响应数据类型
     */
    RES(1);


    private final int cmdCode;

    WsResponseCmdEnum(int uriCode) {
        this.cmdCode = uriCode;
    }


    public int getCmdCode() {
        return cmdCode;
    }
}
