package com.wecloud.im.controller;

import cn.hutool.crypto.digest.MD5;
import com.wecloud.im.param.GetSignParam;
import com.wecloud.im.service.ImClientLoginService;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * sign 控制器
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@RestController
@RequestMapping("/signDemo")
@Api(value = "signAPI", tags = {"获取sign(Demo)"})
public class SignController extends BaseController {

    @Autowired
    private ImClientLoginService imClientLoginService;

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     */
    @PostMapping("/get")
    @ApiOperation(value = "获取sign(仅测试使用)", notes = "生成签名测试,在生产环境中,此步骤需要第三方应用的服务端进行生成")
    public String get(@RequestBody GetSignParam getSignParam) throws Exception {

        return new MD5().digestHex(getSignParam.getTimestamp() + getSignParam.getClientId() + getSignParam.getAppKey() + getSignParam.getAppSecret());
    }

}

