package com.wecloud.im.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Author wenzhida
 * @Date 2022/4/27 11:44
 * @Description 用户进入聊天室入参
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "用户进入聊天室入参")
public class IntoChatRoomParam extends BaseEntity {

    private static final long serialVersionUID = -3602523207000275557L;

    @ApiModelProperty("聊天室id")
    private Long chatRoomId;

    @ApiModelProperty("进入聊天室的clientId")
    private String clientId;

    @ApiModelProperty("客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs, 需与生成sign时的值一致")
    private Integer platform;

}
