# wecloud-RTC音视频客户端对接文档

## 文档描述

此文档为单人RTC音视频通讯技术对接文档

由于RTC基于wecloud-im即时通讯服务,**对接RTC前,需要先对接wecloud-im服务**

## 流程图

![单人WebRTC发起流程图](https://tva1.sinaimg.cn/large/008i3skNgy1guxhnn6x64j60jr0xgmz302.jpg)

# 指令说明

subType子类型:
创建会话:create
接收到RTC:rtcCall

## 发起RTC音视频通话

client发送方向服务端发送数据:
```json
{
"reqId":"555111",
"cmd":3,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":null,
  "toClient":"client_3030",
  "subType":"create",
  "push":{
    "title":"xxx正在邀请你视频通话",
    "subTitle":"点击接听"
  },
  "attrs":{
    "a":"示例: 用户自定义的一些键值对",
    "b":"示例: 存储用户自定义的一些键值对"
   }
	}
}
```

**说明:** toConversation会话ID可以为空, 为空时通话记录将不会记录到会话当中, 如"未接听", "已拒绝"等事件通知不会写入到会话的聊天记录中.

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 是      | 会话id,可为空             |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| push | String     | 是       | 接收方展示的推送内容               |
| subType | String     | 否       | 子类型              |
| toClient | String     | 否       | 被邀请的客户端ID              |

## 接收方收到RTC音视频通话邀请

服务端向client接收方下发数据:

```json
{
"reqId":"",
"cmd":4,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":null,
  "subType":"rtcCall",
  "sender":"client_1010",
  "attrs":{
    "a":"示例: 用户自定义的一些键值对",
    "b":"存储用户自定义的一些键值对"
  }
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 否       | 会话id                 |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subType | String     | 否       | 子类型              |
| sender | String     | 否       | 发起通话的客户端ID              |

## 接收方同意加入房间
client接收方向服务端发送数据:

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":1402147846261706752,
  "subType":"agree",
  "attrs":{}We 
	}
}
```

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 否       | 会话id                 |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subType | String     | 否       | 子类型              |

### 通知发送方:  接收方同意加入房间
服务端向发送方下发数据:
```json
{
"reqId":"123",
"cmd":4,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":1402147846261706752,
  "subType":"agree"
	}
}
```

## 接收方拒绝加入房间

client接收方向服务端发送数据:

```json
{
"reqId":"123",
"cmd":3,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":1402147846261706752,
  "subType":"reject",
  "attrs":{}
	}
}
```

**说明:** 

**参数描述**

| 字段名  | 字段类型 | 是否可空 | 说明 |
| ---- | -------- | -- | ------ |
| cmd            | String   | 否       | 指令码                 |
| attrs          | Object   | 是       | 自定义拓展字段		 |
| toConversation | Long     | 否       | 会话id                 |
| diyParam自定义字段 | Object     | 是       | 自定义拓展字段        |
| subType | String     | 否       | 子类型              |


### 通知发送方:  接收方拒绝加入房间
服务端向发送方下发数据:

```json
{
"reqId":"123",
"cmd":4,
"data":{
  "diyParam自定义字段":"aaaa自已定义字段的值",
  "toConversation":1402147846261706752,
  "subType":"reject"
	}
}
```


## 流媒体描述信息SDP转发
（服务端仅负责转发）（ice_candidate,anser,offer）

## 视频切音频

## 离开房间

## 系统电话繁忙

## 断线重连

## 发送心跳

## 对方是否还挂起

## 挂断

## 确认离开

## 确认是否离开

## 查询对方是否离开
