package com.wecloud.im.action;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.dispatch.common.BaseRequest;
import com.wecloud.dispatch.extend.ActionRequest;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.entity.ImMessageOnlineSend;
import com.wecloud.im.param.ChatContentVo;
import com.wecloud.im.param.ImClientSimpleDto;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.param.MsgVo;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientBlacklistService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.thousandchat.cache.ThousandChatCacheManager;
import com.wecloud.im.ws.enums.WsResponseCmdEnum;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.sender.AsyncPush;
import com.wecloud.im.ws.sender.ChannelSender;
import com.wecloud.utils.JsonUtils;
import com.wecloud.utils.SnowflakeUtil;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioSocketChannel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description 处理Cmd请求
 * 抽象类 策略设计模式
 * @Author hewei hwei1233@163.com
 * @Date 2020-01-02
 */
@Slf4j
@Component
@ActionMapping(value = "/chat")
public class NormalChatAction {

    @Autowired
    private ImApplicationService imApplicationService;
    @Autowired
    private ImClientService imClientService;
    @Autowired
    private ImConversationService imConversationService;
    @Autowired
    private AsyncPush systemPush;
    @Autowired
    private ImConversationMembersService imConversationMembersService;
    @Autowired
    private ImMessageService imMessageService;
    @Autowired
    private ChannelSender channelSender;
    @Autowired
    private ThousandChatCacheManager thousandChatCacheManager;
    @Autowired
    private ImClientBlacklistService imClientBlacklistService;
    @Autowired
    private ImInboxService imInboxService;

    @ActionMapping("/normal/send")
    public void sendMsg(ActionRequest request, ChatContentVo data, String reqId) {
        if (log.isDebugEnabled()) {
            log.debug("接收到参数，reqId: {},\n data: {}, ", data);
        }

        //查看接收的群属性，是否万人群
        ImConversationQueryVo conversation = imConversationService.getCacheImConversationById(data.getToConversation());

        if (conversation == null) {
            log.warn("会reqId: {} ,会话id: {}db中不存在", reqId, data.getToConversation());
            return;
        }

        // 查询发送者client
        ImClient imClientSender = imClientService.getCacheImClient(request.getSenderClientId());
        if (imClientSender == null) {
            log.warn("根据senderClientId: {} 查找不到 imClientSender！", request.getSenderClientId());
            return;
        }

        // 查询imApplication
        ImApplication imApplication = imApplicationService.getCacheById(imClientSender.getFkAppid());
        if (imApplication == null) {
            log.warn("根据appId: {} 查找不到 imApplication！", imClientSender.getFkAppid());
            return;
        }

        // 给所有人（在线+离线）遍历发送
        // 先查询该会话所有成员
        List<ImConversationMembers> membersList = imConversationMembersService.list(
                new QueryWrapper<ImConversationMembers>().lambda()
                        .eq(ImConversationMembers::getFkConversationId, data.getToConversation())
        );
        if (membersList.isEmpty()) {
            log.info("查询会话所有成员返回空，会话ID: {}", data.getToConversation());
            return;
        }
        // 判断为单聊
        if (membersList.size() == 2) {
            // 判断是否被拉黑逻辑
            if (black(reqId, imClientSender, membersList, request.getSenderChannel())) {
                return;
            }
        }

        ImMessageOnlineSend imMessageOnlineSend = assembleImMessageOnlineSend(data, imClientSender, imApplication.getId());

        // 在线用户直接发消息
        sendMsgForOnline(data, imMessageOnlineSend);

        // 再给所有人发 todo 需要改成批量
        for (ImConversationMembers conversationMembers : membersList) {
            // 入库 保存收件箱
            long imInboxId = SnowflakeUtil.getId();
            saveImInbox(imApplication, data.getToConversation(), imMessageOnlineSend.getMsgId(), conversationMembers, imInboxId);

            // 查询接收方
            ImClient imClientReceiver = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                    .eq(ImClient::getFkAppid, imApplication.getId())
                    .eq(ImClient::getId, conversationMembers.getFkClientId()));
            if (imClientReceiver == null) {
                continue;
            }
            // 异步推送系统通知消息
            systemPush.push(data.getPush(), imClientReceiver, imApplication);
        }

        // 响应发送方消息id等信息
        response(reqId, imMessageOnlineSend.getMsgId(), request.getSenderChannel());

    }

    /**
     * 发送消息给在线客户
     * @param data
     * @param imMessageOnlineSend
     */
    private void sendMsgForOnline(ChatContentVo data, ImMessageOnlineSend imMessageOnlineSend) {
        Map<String /** ip **/, List<String /** client的主键ID:platform **/>> onlineIpClientMap =
                thousandChatCacheManager.findOnlineHostsByThousandGroupId(data.getToConversation());
        //  封装要推给接收方的消息
        WsResponse<ImMessageOnlineSend> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.ONLINE_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(imMessageOnlineSend);
        responseModel.setReqId(null);

        onlineIpClientMap.forEach((ip, clientIdAndPlatforms) -> {
            channelSender.batchSendMsg(responseModel, ip, clientIdAndPlatforms);
        });
    }

    /**
     * 拼装发送消息体
     * @param data
     * @param imClientSender
     * @param appId
     * @return
     */
    private ImMessageOnlineSend assembleImMessageOnlineSend(ChatContentVo data, ImClient imClientSender, Long appId) {
        // 生成消息id
        long messageId = SnowflakeUtil.getId();
        // 入库  保存消息至消息表
        ImClientSimpleDto client = new ImClientSimpleDto().setId(imClientSender.getId()).setFkAppid(appId);
        ImMessage imMessage = imMessageService.saveImMessage(client, messageId, data);

        // 封装响应的实体
        ImMessageOnlineSend imMessageOnlineSend = new ImMessageOnlineSend();
        imMessageOnlineSend.setMsgId(imMessage.getId());
        imMessageOnlineSend.setSender(imClientSender.getClientId());
        Map<String, Object> content = JsonUtils.beanCopyDeep(data, Map.class);
        //action的属性无需要返回
        content.remove(BaseRequest.ACTION);
        imMessageOnlineSend.setContent(content);
        imMessageOnlineSend.setConversationId(data.getToConversation());
        imMessageOnlineSend.setCreateTime(imMessage.getCreateTime());
        imMessageOnlineSend.setWithdrawTime(imMessage.getWithdrawTime());
        imMessageOnlineSend.setWithdraw(imMessage.getWithdraw());
        imMessageOnlineSend.setEvent(imMessage.getEvent());
        imMessageOnlineSend.setSystemFlag(imMessage.getSystemFlag());
        imMessageOnlineSend.setType(data.getType());
        imMessageOnlineSend.setAt(imMessage.getAt());
        return imMessageOnlineSend;
    }

    /**
     * 响应发送方消息id等信息
     *
     * @param reqId
     * @param messageId
     * @param channel
     */
    private void response(String reqId, long messageId, Channel channel) {
        WsResponse<MsgVo> responseModel = new WsResponse<>();
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCmd(WsResponseCmdEnum.RES.getCmdCode());
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(new MsgVo(messageId));
        responseModel.setReqId(reqId);
        // 响应发送方
        channelSender.sendMsgLocal((NioSocketChannel)channel, responseModel);
    }

    /**
     * 入库 保存收件箱
     *
     * @param imApplication
     * @param toConversationId
     * @param messageId
     * @param conversationMembers
     * @param imInboxId
     */
    private void saveImInbox(ImApplication imApplication, Long toConversationId, long messageId, ImConversationMembers conversationMembers, long imInboxId) {
        ImInbox imInbox = new ImInbox();
        imInbox.setId(imInboxId);
        imInbox.setCreateTime(new Date());
        imInbox.setFkAppid(imApplication.getId());
        imInbox.setReceiver(conversationMembers.getFkClientId());
        imInbox.setFkMsgId(messageId);
        imInbox.setReadMsgStatus(0);
        imInbox.setReceiverMsgStatus(0);
        imInbox.setFkConversationId(toConversationId);
        imInboxService.save(imInbox);
    }

    /**
     * 判断是否被拉黑
     *
     * @param reqId
     * @param imClientSender
     * @param membersList
     * @param channel
     * @return
     */
    private boolean black(String reqId, ImClient imClientSender, List<ImConversationMembers> membersList, Channel channel) {
        Long meId = imClientSender.getId();
        Long heId = null;
        if(membersList.get(0).getFkClientId().equals(meId)) {
            heId = membersList.get(1).getFkClientId();
        } else {
            heId = membersList.get(0).getFkClientId();
        }
        // 判断是否被拉黑
        boolean beBlack = imClientBlacklistService.isBeBlack(heId, meId);
        if (beBlack) {
            log.info("被对方拉黑了, meId={},heId={}", meId, heId);

            // 响应发送方
            WsResponse<HashMap<String, Long>> responseModel = new WsResponse<>();
            ApiResult<Boolean> result = ApiResult.result(ApiCode.IS_BE_BLACK);
            responseModel.setCmd(WsResponseCmdEnum.RES.getCmdCode());
            responseModel.setCode(result.getCode());
            responseModel.setMsg(result.getMessage());
            responseModel.setReqId(reqId);

            channelSender.sendMsgLocal((NioSocketChannel)channel, responseModel);

            return true;
        }

        // 是否把对方拉黑
        boolean black = imClientBlacklistService.isBeBlack(meId, heId);
        if (black) {
            log.info("你把对方拉黑了, meId={},heId={}", meId, heId);
            // 响应发送方
            WsResponse<HashMap<String, Long>> responseModel = new WsResponse<>();
            ApiResult<Boolean> result = ApiResult.result(ApiCode.IS_TO_BLACK);
            responseModel.setCmd(WsResponseCmdEnum.RES.getCmdCode());
            responseModel.setCode(result.getCode());
            responseModel.setMsg(result.getMessage());
            responseModel.setReqId(reqId);

            channelSender.sendMsgLocal((NioSocketChannel)channel, responseModel);

            return true;
        }
        return false;
    }
}
