


/*
 Navicat Premium Data Transfer

 Source Server         : 小虎豆-test
 Source Server Type    : MySQL
 Source Server Version : 50730
 Source Host           : 124.71.83.11:3306
 Source Schema         : wecloud_im

 Target Server Type    : MySQL
 Target Server Version : 50730
 File Encoding         : 65001

 Date: 19/10/2022 15:52:33
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for im_application
-- ----------------------------
DROP TABLE IF EXISTS `im_application`;
CREATE TABLE `im_application`  (
                                   `id` bigint(20) NOT NULL COMMENT '应用appid',
                                   `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                   `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                   `app_key` varchar(200) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT 'key',
                                   `app_secret` varchar(500) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '密钥',
                                   `app_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'app名称',
                                   `ios_push_channel` int(255) NULL DEFAULT NULL COMMENT 'ios推送通道,友盟:1;firebase:2; apns原生:3',
                                   `android_push_channel` int(255) NULL DEFAULT NULL COMMENT '安卓推送通道,友盟:1;firebase:2; 信鸽3',
                                   `umeng_key` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '友盟推送key',
                                   `umeng_secret` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '友盟推送密钥',
                                   `firebase_secret` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'firebase推送密钥',
                                   `repeat_session_status` int(1) NULL DEFAULT 0 COMMENT '是否允许创建重复会话 0不允许 1允许',
                                   `contrast_extended_field_status` int(1) NULL DEFAULT 0 COMMENT '创建会话时对比扩展字段  0不  1是',
                                   `online_status_subscribe_url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '在线状态订阅地址',
                                   `full_message_subscribe_url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '全量消息订阅地址',
                                   `tenant_id` bigint(20) NULL DEFAULT NULL,
                                   `ios_umeng_key` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '友盟推送key',
                                   `ios_umeng_secret` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '友盟推送密钥',
                                   PRIMARY KEY (`id`) USING BTREE,
                                   UNIQUE INDEX `app_key`(`app_key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '第三方应用表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_client
-- ----------------------------
DROP TABLE IF EXISTS `im_client`;
CREATE TABLE `im_client`  (
                              `id` bigint(20) NOT NULL COMMENT '客户端id',
                              `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                              `last_offline_time` timestamp NULL DEFAULT NULL COMMENT '最后离线时间',
                              `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                              `fk_appid` bigint(20) NULL DEFAULT NULL COMMENT '应用appid',
                              `attributes` json NULL COMMENT '可选	自定义属性，供开发者扩展使用',
                              `client_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户方提供的唯一id',
                              `valid` int(1) NULL DEFAULT NULL COMMENT '设备不想收到推送提醒',
                              `device_type` int(1) NULL DEFAULT NULL COMMENT '设备类型1:ios; 2:android',
                              `device_token` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备推送token',
                              `head_portrait` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
                              `nickname` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主昵称',
                              `platform` int(11) NULL DEFAULT NULL COMMENT '平台编码：客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs',
                              PRIMARY KEY (`id`) USING BTREE,
                              UNIQUE INDEX ```fk_appid``, ``client_id```(`fk_appid`, `client_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '终端表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_client_blacklist
-- ----------------------------
DROP TABLE IF EXISTS `im_client_blacklist`;
CREATE TABLE `im_client_blacklist`  (
                                        `id` bigint(20) NOT NULL COMMENT '客户端id',
                                        `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                        `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                        `fk_appid` bigint(20) NULL DEFAULT NULL COMMENT '应用appid',
                                        `client_id_prevent` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拉黑者',
                                        `client_id_be_prevent` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被拉黑',
                                        PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '黑名单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_client_device
-- ----------------------------
DROP TABLE IF EXISTS `im_client_device`;
CREATE TABLE `im_client_device`  (
                                     `id` bigint(20) NOT NULL COMMENT '主键id',
                                     `fk_appid` bigint(20) NULL DEFAULT NULL COMMENT '应用appid',
                                     `fk_client_id` bigint(20) NOT NULL COMMENT '客户端id',
                                     `valid` int(11) NULL DEFAULT NULL COMMENT '设备不想收到推送提醒',
                                     `device_type` int(11) NULL DEFAULT NULL COMMENT '设备类型1:ios; 2:android',
                                     `device_token` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备推送token',
                                     `unique_device_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备唯一id(由设备端生成)',
                                     `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                     `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                     PRIMARY KEY (`id`) USING BTREE,
                                     INDEX `idx_fk_client_id`(`fk_client_id`) USING BTREE,
                                     INDEX `idx_device_token_appid`(`device_token`, `fk_appid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客户端设备表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_conversation
-- ----------------------------
DROP TABLE IF EXISTS `im_conversation`;
CREATE TABLE `im_conversation`  (
                                    `id` bigint(20) NOT NULL COMMENT '会话id',
                                    `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                    `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                    `last_message` timestamp NULL DEFAULT NULL COMMENT '对话中最后一条消息的发送或接收时间',
                                    `member_count` int(11) NULL DEFAULT NULL COMMENT '群成员数',
                                    `chat_type` tinyint(4) NULL DEFAULT NULL COMMENT '是否万人群',
                                    `fk_appid` bigint(20) NOT NULL COMMENT '应用appid',
                                    `creator` bigint(20) NOT NULL COMMENT '创建者客户端id',
                                    `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可选	 对话的名字，可为群组命名。',
                                    `attributes` json NULL COMMENT '可选	自定义属性，供开发者扩展使用。',
                                    `system_flag` tinyint(1) NULL DEFAULT NULL COMMENT '可选	对话类型标志，是否是系统对话，后面会说明。',
                                    `muted` tinyint(4) NOT NULL DEFAULT 1 COMMENT '禁言开关 1-未禁言 2-禁言',
                                    `is_forbid_add_friend` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否禁止群里互加好友0否1是',
                                    `is_forbid_send_pic` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否禁止发图片0否1是',
                                    `is_forbid_send_link` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否禁止发链接0否1是',
                                    `group_portrait` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '群头像',
                                    `head_portrait` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '群头像',
                                    `is_encrypt` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '是否加密聊天： 1-是 0-否',
                                    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会话表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_conversation_members
-- ----------------------------
DROP TABLE IF EXISTS `im_conversation_members`;
CREATE TABLE `im_conversation_members`  (
                                            `id` bigint(20) NOT NULL COMMENT '唯一id',
                                            `create_time` timestamp NULL DEFAULT NULL COMMENT '加入时间',
                                            `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                            `fk_appid` bigint(20) NOT NULL COMMENT '应用appid',
                                            `fk_conversation_id` bigint(20) NOT NULL COMMENT '会话表id',
                                            `fk_client_id` bigint(20) NOT NULL COMMENT '客户端id',
                                            `display_status` int(2) NULL DEFAULT 1 COMMENT '单向删除(隐藏)会话, 0不显示, 1显示',
                                            `allow_system_push_status` int(2) NULL DEFAULT 1 COMMENT '是否允许系统推送, 0不推送, 1推送',
                                            `attributes` json NULL COMMENT '可选	自定义属性，供开发者扩展使用',
                                            `client_remark_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '会话中client的备注名',
                                            `role` tinyint(4) NOT NULL DEFAULT 1 COMMENT '角色 1-普通群成员 2-管理员 3-群主',
                                            `muted` tinyint(4) NOT NULL DEFAULT 1 COMMENT '禁言开关 1-未禁言 2-禁言',
                                            `client_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户方提供的唯一id',
                                            `is_do_not_disturb` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '免打扰开关 0-关闭 1开启',
                                            `is_top` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '置顶开关 0-关闭 1开启',
                                            `join_type_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '进群方式编码',
                                            `join_type_msg` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '进群方式信息',
                                            PRIMARY KEY (`id`) USING BTREE,
                                            INDEX `fk_conversation_id`(`fk_conversation_id`) USING BTREE,
                                            INDEX `fk_client_id`(`fk_client_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会话成员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_friend
-- ----------------------------
DROP TABLE IF EXISTS `im_friend`;
CREATE TABLE `im_friend`  (
                              `id` bigint(20) NOT NULL COMMENT '主键id',
                              `client_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '自己id',
                              `client_id_friend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '好友id',
                              `client_id_claimer` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '好友申请者',
                              `friend_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '好友名称备注',
                              `reject_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拒绝说明',
                              `request_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '好友请求说明',
                              `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '好友状态，1：待确定，2：已确认，3：已拒绝，4：已删除',
                              `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                              `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                              PRIMARY KEY (`id`) USING BTREE,
                              UNIQUE INDEX `friend_id`(`client_id`, `client_id_friend`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '好友表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_friend_recommend
-- ----------------------------
DROP TABLE IF EXISTS `im_friend_recommend`;
CREATE TABLE `im_friend_recommend`  (
                                        `id` bigint(20) NOT NULL COMMENT '主键id',
                                        `client_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '自己id',
                                        `client_id_friend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '好友id',
                                        `source` tinyint(4) NULL DEFAULT NULL COMMENT '推荐来源',
                                        `del_flag` bit(1) NOT NULL DEFAULT b'0' COMMENT '删除标识',
                                        `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                        `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                        PRIMARY KEY (`id`) USING BTREE,
                                        UNIQUE INDEX `friend_id`(`client_id`, `client_id_friend`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '好友表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_inbox
-- ----------------------------
DROP TABLE IF EXISTS `im_inbox`;
CREATE TABLE `im_inbox`  (
                             `id` bigint(20) NOT NULL COMMENT '收件id',
                             `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                             `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                             `read_time` timestamp NULL DEFAULT NULL COMMENT '读取时间',
                             `receiver_time` timestamp NULL DEFAULT NULL COMMENT '接收时间',
                             `fk_appid` bigint(20) NOT NULL COMMENT '应用appid',
                             `receiver` bigint(20) NOT NULL COMMENT '接收客户端id',
                             `fk_msg_id` bigint(20) NOT NULL COMMENT '消息id',
                             `read_msg_status` int(1) NULL DEFAULT NULL COMMENT '0未读; 1已读',
                             `receiver_msg_status` int(1) NULL DEFAULT NULL COMMENT '0未接收; 1已接收',
                             `fk_conversation_id` bigint(20) NOT NULL COMMENT '会话id',
                             PRIMARY KEY (`id`) USING BTREE,
                             INDEX `getMyOfflineMsg`(`receiver`) USING BTREE,
                             INDEX `idx_create_time`(`create_time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息收件箱表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_ios_apns
-- ----------------------------
DROP TABLE IF EXISTS `im_ios_apns`;
CREATE TABLE `im_ios_apns`  (
                                `id` bigint(20) NOT NULL COMMENT 'id',
                                `fk_app_id` bigint(20) NOT NULL COMMENT '应用appid',
                                `apns_file_value` text CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL COMMENT 'Base64(apns.p12)',
                                `env` int(255) NULL DEFAULT NULL COMMENT '环境,正式1,测试0',
                                `bundle_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'bundle_id',
                                `pwd` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证书密码',
                                PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'apns配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_message_new
-- ----------------------------
DROP TABLE IF EXISTS `im_message_new`;
CREATE TABLE `im_message_new`  (
                                   `id` bigint(20) NOT NULL COMMENT '消息id',
                                   `fk_conversation_id` bigint(20) NULL DEFAULT NULL COMMENT '会话id',
                                   `fk_appid` bigint(20) NOT NULL COMMENT '应用appid',
                                   `create_time` timestamp(3) NULL DEFAULT NULL COMMENT '创建时间',
                                   `withdraw_time` timestamp NULL DEFAULT NULL COMMENT '撤回时间',
                                   `update_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                   `sender` bigint(20) NULL DEFAULT NULL COMMENT '发送者客户端id',
                                   `content` json NULL COMMENT '内容',
                                   `withdraw` tinyint(1) NULL DEFAULT 0 COMMENT '0未撤回; 1已撤回',
                                   `event` tinyint(1) NULL DEFAULT 0 COMMENT '0非事件; 1为事件',
                                   `system_flag` tinyint(1) NULL DEFAULT 0 COMMENT '0非系统通知; 1为系统通知',
                                   `at` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT 'at他人,传入客户端id数组',
                                   `send_status` int(2) NULL DEFAULT NULL COMMENT '发送状态\n1AVIMMessageStatusSending（发送中）\n2AVIMMessageStatusSent（发送成功）\n3AVIMMessageStatusFailed（失败）',
                                   `msg_type` int(2) NULL DEFAULT NULL COMMENT '消息类型',
                                   `is_delete` tinyint(4) NOT NULL DEFAULT 1 COMMENT '是否删除 1-未删除 2-删除',
                                   `receivers` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收人,多人用英文逗号分隔-群内指定人员可见场景',
                                   `pre_message_id` bigint(20) NULL DEFAULT NULL COMMENT '前一条消息的id',
                                   PRIMARY KEY (`id`) USING BTREE,
                                   INDEX ```fk_conversation_id```(`fk_conversation_id`) USING BTREE,
                                   INDEX `idx_sender`(`sender`) USING BTREE,
                                   INDEX `idx_create_time`(`create_time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '消息存储表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_multi_rtc_room
-- ----------------------------
DROP TABLE IF EXISTS `im_multi_rtc_room`;
CREATE TABLE `im_multi_rtc_room`  (
                                      `id` bigint(20) NOT NULL COMMENT '主键id',
                                      `fk_appid` bigint(20) NULL DEFAULT NULL COMMENT '应用appid',
                                      `room_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '房间id(live kit提供)',
                                      `state` tinyint(4) NOT NULL DEFAULT 1 COMMENT '房间状态，1：已创建，2：会议中，3：会议结束',
                                      `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                      `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                      PRIMARY KEY (`id`) USING BTREE,
                                      INDEX `idx_room_id`(`room_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '多人音视频房间表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_multi_rtc_room_member
-- ----------------------------
DROP TABLE IF EXISTS `im_multi_rtc_room_member`;
CREATE TABLE `im_multi_rtc_room_member`  (
                                             `id` bigint(20) NOT NULL COMMENT '主键id',
                                             `fk_rtc_room_id` bigint(20) NOT NULL COMMENT 'im房间id',
                                             `room_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '房间id(live kit提供)',
                                             `fk_client_id` bigint(20) NOT NULL COMMENT 'client主键id',
                                             `client_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户方提供的唯一id',
                                             `state` tinyint(4) NOT NULL DEFAULT 1 COMMENT '房间成员状态，1：呼叫中，2：已接听，3：已拒绝，4：未接听，5：已断开',
                                             `call_time` timestamp NULL DEFAULT NULL COMMENT '呼叫时间',
                                             `heartbeat_time` timestamp NULL DEFAULT NULL COMMENT '心跳时间',
                                             `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                             `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                             PRIMARY KEY (`id`) USING BTREE,
                                             INDEX `idx_fk_rtc_room_id`(`fk_rtc_room_id`) USING BTREE,
                                             INDEX `idx_room_id`(`room_id`) USING BTREE,
                                             INDEX `idx_call_time_state`(`call_time`, `state`) USING BTREE,
                                             INDEX `idx_heartbeat_time_state`(`heartbeat_time`, `state`) USING BTREE,
                                             INDEX `idx_client_id`(`client_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '多人音视频房间成员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_rtc_channel
-- ----------------------------
DROP TABLE IF EXISTS `im_rtc_channel`;
CREATE TABLE `im_rtc_channel`  (
                                   `id` bigint(20) NOT NULL COMMENT '会话id',
                                   `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                   `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                   `fk_appid` bigint(20) NOT NULL COMMENT '外键 应用appid',
                                   `fk_conversation` bigint(20) NULL DEFAULT NULL COMMENT '外键 会话id 可为空',
                                   `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '可选	 对话的名字，可为群组命名。',
                                   `attributes` json NULL COMMENT '可选	自定义属性，供开发者扩展使用。',
                                   `channel_status` int(1) NULL DEFAULT NULL COMMENT '频道状态, 1打开 , 0关闭',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'Rtc频道表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_rtc_log
-- ----------------------------
DROP TABLE IF EXISTS `im_rtc_log`;
CREATE TABLE `im_rtc_log`  (
                               `id` bigint(20) NOT NULL COMMENT 'rtc记录id',
                               `fk_appid` bigint(20) NOT NULL COMMENT '应用appid',
                               `fk_channel_id` bigint(20) NULL DEFAULT NULL COMMENT '频道id',
                               `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                               `update_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                               `fk_conversation` bigint(20) NULL DEFAULT NULL COMMENT '外键 会话id 可为空',
                               `client_id` bigint(20) NULL DEFAULT NULL COMMENT '事件主体客户端id',
                               `event_type` int(1) NULL DEFAULT NULL COMMENT '事件类型 1成为房主, 2加入频道,3退出频道,4拒绝邀请 ,5上传sdp, 6上传candidate',
                               `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '备注',
                               PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'RTC日志记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_rtc_record
-- ----------------------------
DROP TABLE IF EXISTS `im_rtc_record`;
CREATE TABLE `im_rtc_record`  (
                                  `id` bigint(20) NOT NULL COMMENT '主键id',
                                  `fk_appid` bigint(20) NULL DEFAULT NULL COMMENT '应用appid',
                                  `channel_id` bigint(20) NULL DEFAULT NULL COMMENT '频道id',
                                  `from_client_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发起方clientId',
                                  `to_client_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接收方clientId',
                                  `state` tinyint(4) NOT NULL DEFAULT 1 COMMENT '频道状态，1：音视频发起，2：音视频中，3：音视频结束',
                                  `call_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '音视频类型: 1-video或2-voice',
                                  `start_time` timestamp NULL DEFAULT NULL COMMENT '音视频开始时间',
                                  `end_time` timestamp NULL DEFAULT NULL COMMENT '音视频结束时间',
                                  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                  `offline_times` tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '通话过程中离线次数统计',
                                  PRIMARY KEY (`id`) USING BTREE,
                                  INDEX `idx_channel_id`(`channel_id`) USING BTREE,
                                  INDEX `idx_state_create_time`(`state`, `create_time`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '单人音视频聊天记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for im_user
-- ----------------------------
DROP TABLE IF EXISTS `im_user`;
CREATE TABLE `im_user`  (
                            `id` bigint(20) NOT NULL COMMENT '主键id',
                            `id_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '蓝豆号',
                            `phone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
                            `id_card_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
                            `email` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮箱号码',
                            `password` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
                            `sex` tinyint(4) NULL DEFAULT 3 COMMENT '性别 1-男 2-女 3-未知',
                            `head_portrait` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
                            `nickname` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '昵称',
                            `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                            `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                            PRIMARY KEY (`id`) USING BTREE,
                            UNIQUE INDEX `phone`(`phone`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for meet_record
-- ----------------------------
DROP TABLE IF EXISTS `meet_record`;
CREATE TABLE `meet_record`  (
                                `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
                                `app_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '应用标识',
                                `client_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端id',
                                `room_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '会议id',
                                `join_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '加入时间',
                                `close_time` timestamp NULL DEFAULT NULL COMMENT '退出时间',
                                `duration` bigint(20) NULL DEFAULT NULL COMMENT '单位:秒',
                                `livekit_sid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '流媒体服务短id',
                                PRIMARY KEY (`id`) USING BTREE,
                                INDEX `room_id`(`room_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;





