package com.wecloud.im.service;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.param.ApiImConversationMembersPageParam;
import com.wecloud.im.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.ImConversationMembersPageParam;
import com.wecloud.im.param.ImConversationMembersQueryVo;
import com.wecloud.im.param.SetAdminsParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.vo.ConversationMemberVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 会话成员表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationMembersService extends BaseService<ImConversationMembers> {


    /**
     * 服务端api-会话成员表分页列表
     *
     * @param apiImConversationMembersPageParam
     * @param imApplication
     * @return
     */
    ApiResult<List<ApiImConversationMembersQueryVo>> getRestApiImConversationMembersList(ApiImConversationMembersPageParam apiImConversationMembersPageParam, ImApplication imApplication);


    ApiResult<Boolean> saveOrUpdateClientRemarkName(ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam);


    /**
     * 会话成员表分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    List<ConversationMemberVo> getImConversationMembersList(ListConversationMembersParam param);


    ApiResult<Boolean> saveOrUpdateAttr(ImConversationMemAttrUpdate imConversationMemAttrUpdate);

    /**
     * 保存
     *
     * @param imConversationMembers
     * @return
     * @throws Exception
     */
    boolean saveImConversationMembers(ImConversationMembers imConversationMembers) throws Exception;

    /**
     * 修改
     *
     * @param imConversationMembers
     * @return
     * @throws Exception
     */
    boolean updateImConversationMembers(ImConversationMembers imConversationMembers) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImConversationMembers(Long id);

    /**
     * 根据会话id做删除
     * @param conversationId 会话id
     */
    void deleteByConversationId(Long conversationId);

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationMembersQueryVo getImConversationMembersById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imConversationMembersPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationMembersQueryVo> getImConversationMembersPageList(ImConversationMembersPageParam imConversationMembersPageParam) throws Exception;

    /**
     * 根据用户id 获取千人群id列表
     * @param clientId 用户id
     * @return
     */
    List<Long> findThousandGroupsByClientId(Long clientId);

    /**
     * 批量设置群成员
     * @param param
     * @param fkClientIds
     */
    void setAdminsForConversation(SetAdminsParam param, List<Long> fkClientIds);

}
