package com.wecloud.im.service;

import java.util.List;

import com.wecloud.im.param.group.MutedMembersParam;

/**
 * 群服务
 * @Author luozh
 * @Date 2022年05月10日 15:17
 * @Version 1.0
 */
public interface ImGroupService {

    /**
     * 创建群组
     * @Author luozh
     * @Date 2022年05月10日 03:22:13
     * @param creatorClientId
     * @param groupName
     * @param memberIds
     * @Return
     */
    Long createGroup(String creatorClientId, String groupName, List<String> memberIds);

    /**
     * 解散群组
     * @Author luozh
     * @Date 2022年05月10日 03:22:26
     * @param userId
     * @param groupId
     * @Return
     */
    Boolean dismissGroup(String userId, String groupId);

    /**
     * 加入群组
     * @Author luozh
     * @Date 2022年05月10日 03:22:35
     * @param groupId
     * @param memberClientIds
     * @Return
     */
    Integer joinGroup(String inviterUserId, String groupId, List<String> memberClientIds);

    /**
     * 离开群组
     * @Author luozh
     * @Date 2022年05月10日 03:22:44
     * @param groupId
     * @param memberClientIds
     * @Return
     */
    Integer leaveGroup(String operatorUserId, String groupId, List<String> memberClientIds);

    /**
     * 获取群成员列表
     * @Author luozh
     * @Date 2022年05月10日 03:23:09
     * @param groupId
     * @Return
     */
    List<String> listGroupMembers(String groupId);

    /**
     * 禁言群成员
     * @Author luozh
     * @Date 2022年05月16日 07:43:41
     * @param param
     * @Return
     */
    Boolean mutedMembers(MutedMembersParam param);
}
