package com.wecloud.im.param.add;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 添加或修改推送设备信息
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImClientHeadPortraitAndNicknameUpdate")
public class ImClientHeadPortraitAndNicknameUpdate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "clientId 不能为空")
    @ApiModelProperty("clientId")
    private String clientId;

    @ApiModelProperty("头像,uri地址")
    private String headPortrait;

    @ApiModelProperty("主昵称")
    private String nickname;

}
