package com.wecloud.im.service;

import com.wecloud.dispatch.extend.ActionRequest;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;

/**
 * 请求上下文服务
 * @Author luozh
 * @Date 2022年04月02日 14:51
 * @Version 1.0
 */
public interface ContextService {

    /**
     * 获取当前或指定clientId的ImClient 存在返回 不存在则抛出异常
     * @Author luozh
     * @Date 2022年04月02日 02:52:09
     * @param request Ws请求
     * @Return
     */
    ImClient getImClientIfNotNullOrThrow(ActionRequest request);

    /**
     * 获取当前或指定appId的ImApplication 存在返回 不存在则抛出异常
     * @Author luozh
     * @Date 2022年04月02日 02:54:21
     * @param appId 应用id
     * @Return
     */
    ImApplication getImApplicationIfNotNullOrThrow(Long appId);
}
