package com.jumeirah.api.app.service.impl;


import com.jumeirah.api.app.service.AppSmsService;
import com.jumeirah.api.app.service.AppUserApiService;
import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.app.AppSmsRegisterParam;
import com.jumeirah.common.param.app.AppUserInfoParam;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.vo.app.LoginAppUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppUserApiServiceImpl implements AppUserApiService {

    @Autowired
    private AppSmsService appSmsService;
    @Autowired
    private AppUserService appUserService;

    @Override
    public ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam loginParam, String language) throws Exception {
        // 校验验证码
        boolean equalsRegisterCode = appSmsService.equalsRegisterCode(loginParam.getPhoneArea(), loginParam.getPhone(), loginParam.getSmsCode());
        if (!equalsRegisterCode) {
            return ApiResult.fail(ApiCode.FAIL, new LoginAppUserTokenVo());
        }
        // 删除已使用的验证码
        appSmsService.deleteRegisterCode(loginParam.getPhoneArea(), loginParam.getPhone());
        // 判断是否已经注册
        if (appUserService.hasUserByPhoneNumer(loginParam.getPhoneArea(), loginParam.getPhone())) {
            // 如果已经注册直接走登陆的代码
            return appUserService.login(loginParam, language, true);
        }

        // 没注册则先保存到数据库
        AppUser appUser = new AppUser();
        appUser.setPhoneArea(loginParam.getPhoneArea());
        appUser.setPhone(loginParam.getPhone());
        boolean isDbOk = appUserService.saveAppUser(appUser);
        if (!isDbOk) {
            return ApiResult.fail(ApiCode.FAIL, new LoginAppUserTokenVo());
        }

        // 走登陆的代码
        return appUserService.login(loginParam, language, false);
    }

    @Override
    public ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language) throws Exception {
        return null;
    }

    @Override
    public boolean updateAppUser(AppUserInfoParam appUserInfoParam) throws Exception {

        AppUser appUser = new AppUser();
        BeanUtils.copyProperties(appUserInfoParam, appUser);

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        appUser.setId(jwtToken.getUserId());

        return appUserService.updateAppUser(appUser);
    }

}
