CREATE TABLE `im_application` (
                                  `id` bigint(20) NOT NULL COMMENT '应用appid',
                                  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
                                  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
                                  `app_key` varchar(200) CHARACTER SET latin1 DEFAULT NULL COMMENT 'key',
                                  `app_secret` varchar(500) CHARACTER SET latin1 DEFAULT NULL COMMENT '密钥',
                                  `app_name` varchar(200) DEFAULT NULL COMMENT 'app名称',
                                  `ios_push_channel` int(255) DEFAULT NULL COMMENT 'ios推送通道,友盟:1;firebase:2; apns原生:3',
                                  `android_push_channel` int(255) DEFAULT NULL COMMENT '安卓推送通道,友盟:1;firebase:2; 信鸽3',
                                  `umeng_key` varchar(500) DEFAULT NULL COMMENT '友盟推送key',
                                  `umeng_secret` varchar(500) DEFAULT NULL COMMENT '友盟推送密钥',
                                  `firebase_secret` varchar(500) DEFAULT NULL COMMENT 'firebase推送密钥',
                                  `repeat_session_status` int(1) DEFAULT '0' COMMENT '是否允许创建重复会话 0不允许 1允许',
                                  `contrast_extended_field_status` int(1) DEFAULT '0' COMMENT '创建会话时对比扩展字段  0不  1是',
                                  `online_status_subscribe_url` varchar(512) DEFAULT '' COMMENT '在线状态订阅地址',
                                  `full_message_subscribe_url` varchar(512) DEFAULT '' COMMENT '全量消息订阅地址',
                                  `owner_id` bigint(20) DEFAULT NULL COMMENT '所有者id',
                                  `company_id` bigint(20) DEFAULT NULL COMMENT '企业id',
                                  `status` tinyint(1) DEFAULT NULL COMMENT '状态',
                                  PRIMARY KEY (`id`) USING BTREE,
                                  UNIQUE KEY `app_key` (`app_key`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='第三方应用表';


CREATE TABLE `application_products_im_config` (
                                                  `id` bigint(20) NOT NULL COMMENT '主键id',
                                                  `fk_appid` bigint(20) DEFAULT NULL COMMENT '应用id',
                                                  `group_member_limit` int(4) DEFAULT NULL COMMENT '群成员数量上限',
                                                  `group_number_limit` bigint(20) DEFAULT NULL COMMENT '群组数量上限',
                                                  `user_register_limit` bigint(20) DEFAULT NULL COMMENT '用户注册数上限',
                                                  `message_keep_days` int(4) DEFAULT NULL COMMENT '消息存储时长/天',
                                                  `expire_time` datetime DEFAULT NULL COMMENT '到期时间',
                                                  `month_live_user_max` bigint(20) DEFAULT NULL COMMENT '月峰值日活用户',
                                                  `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
                                                  `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
                                                  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                                  `update_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                                  `is_deleted` tinyint(4) unsigned DEFAULT NULL COMMENT '是否删除 0否 1是',
                                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='即时通讯应用产品配置表';

CREATE TABLE `application_products_rtc_config` (
                                                   `id` bigint(20) NOT NULL COMMENT '主键id',
                                                   `fk_appid` bigint(20) DEFAULT NULL COMMENT '应用id',
                                                   `voice_call_time_remain` bigint(20) DEFAULT NULL COMMENT '语音通话时长/分钟',
                                                   `video_call_time_remain` bigint(20) DEFAULT NULL COMMENT '视频通话HD时长/分钟',
                                                   `voice_recording_time_remain` bigint(20) DEFAULT NULL COMMENT '音频录制时长/分钟',
                                                   `video_recording_time_remain` bigint(20) DEFAULT NULL COMMENT '视频录制HD时长/分钟',
                                                   `voice_call_expire_time` datetime DEFAULT NULL COMMENT '语音通话到期时间',
                                                   `video_call_expire_time` datetime DEFAULT NULL COMMENT '视频通话到期时间',
                                                   `voice_recording_expire_time` datetime DEFAULT NULL COMMENT '音频录制到期时间',
                                                   `video_recording_expire_time` datetime DEFAULT NULL COMMENT '视频录制到期时间',
                                                   `create_by` bigint(20) DEFAULT NULL COMMENT '创建人id',
                                                   `update_by` bigint(20) DEFAULT NULL COMMENT '更新人id',
                                                   `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                                   `update_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                                   `is_deleted` tinyint(1) unsigned DEFAULT NULL COMMENT '是否删除 0否 1是',
                                                   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Rtc应用产品配置表';