package com.wecloud.rtc.productsconfig;

import com.wecloud.imserver.client.api.RtcApplicationProductsConfig;
import com.wecloud.imserver.client.model.ao.RtcApplicationProductsConfigAO;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.dto.RtcApplicationProductsConfigDTO;
import com.wecloud.rtc.entity.ApplicationProductsRtcConfig;
import com.wecloud.rtc.service.IApplicationProductsRtcConfigService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author nanqianhao
 * @date 2022/6/9
 * @apiNote
 */
@Slf4j
@Service
@DubboService
public class RtcApplicationProductsConfigImpl implements RtcApplicationProductsConfig {

    @Autowired
    private IApplicationProductsRtcConfigService applicationProductsRtcConfigService;

    @Override
    public Result<Boolean> createOrUpdateRtcApplicationProductsConfig(RtcApplicationProductsConfigAO rtcApplicationProductsConfigAO) {
        log.info("创建rtc应用配置传入参数为{}",rtcApplicationProductsConfigAO);
        ApplicationProductsRtcConfig applicationProductsRtcConfig = new ApplicationProductsRtcConfig();
        if(rtcApplicationProductsConfigAO.getFkAppid()==null){
            return Result.getBusinessException("请传入app应用id", null);
        }
        BeanUtils.copyProperties(rtcApplicationProductsConfigAO,applicationProductsRtcConfig);
        boolean result = applicationProductsRtcConfigService.saveOrUpdate(applicationProductsRtcConfig);
        RtcApplicationProductsConfigDTO rtcApplicationProductsConfigDTO = new RtcApplicationProductsConfigDTO();
        BeanUtils.copyProperties(rtcApplicationProductsConfigDTO,applicationProductsRtcConfig);
        log.info("生成rtc应用配置为{}",rtcApplicationProductsConfigDTO);
        return Result.getSuccessResult(result);
    }

    @Override
    public Result<RtcApplicationProductsConfigDTO> getRtcApplicationProductsConfig(Long id) {
        log.info("查看即时通讯应用配置传入appid为{}",id);
        ApplicationProductsRtcConfig applicationProductsRtcConfig = applicationProductsRtcConfigService.getById(id);
        if (applicationProductsRtcConfig==null||applicationProductsRtcConfig.getIsDeleted().equals(true)){
            return Result.getBusinessException("查无此应用配置", null);
        }
        RtcApplicationProductsConfigDTO rtcApplicationProductsConfigDTO = new RtcApplicationProductsConfigDTO();
        BeanUtils.copyProperties(applicationProductsRtcConfig,rtcApplicationProductsConfigDTO);
        log.info("返回即时通讯应用配置为{}",rtcApplicationProductsConfigDTO);
        return Result.getSuccessResult(rtcApplicationProductsConfigDTO);
    }
}
