package com.jumeirah.common.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.jumeirah.common.entity.SysUser;
import com.jumeirah.common.param.LoginParam;
import com.jumeirah.common.param.RegisterParam;
import com.jumeirah.common.service.RegisterService;
import com.jumeirah.common.vo.LoginSysUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import com.jumeirah.common.service.LoginService;
import com.jumeirah.common.service.SysUserService;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

@Api
@Slf4j
@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    private LoginService loginService;

    @Autowired
    private SysUserService sysUserService;

    @Override
    public ApiResult<LoginSysUserTokenVo> register(RegisterParam registerParam, HttpServletResponse response, String language) throws Exception {

        SysUser sysUser = new SysUser();
        sysUser.setUsername(registerParam.getPhone());
        sysUser.setPhone(registerParam.getPhone());
        sysUser.setNickname(RandomUtil.randomString(8));
        sysUser.setPassword(registerParam.getPassword());
        sysUser.setState(1);
        // h5 用户
        sysUser.setRoleId(24L);
        sysUser.setDepartmentId(205L);

        // 存库
        boolean saveSysUser = sysUserService.saveSysUser(sysUser);

        // 登陆
        LoginParam loginParam = new LoginParam();

        loginParam.setUsername(registerParam.getPhone());
        loginParam.setPassword(registerParam.getPassword());
        return loginService.login(loginParam, response, language);
    }
}
