package com.ym.im.mq;

import com.ym.im.config.RabbitConfig;
import com.ym.im.entity.MsgBody;
import com.ym.im.entity.StaffSocketInfo;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-05-30
 */
@Component
public class Queue {

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitConfig rabbitConfig;

    /**
     * 延迟队列 重发未回应消息
     *
     * @param msgBody
     */
    public void delaysQueue(MsgBody msgBody) {
        // 通过广播模式发布延时消息 延时3秒 消费后销毁 这里无需指定路由，会广播至每个绑定此交换机的队列
        rabbitTemplate.convertAndSend(rabbitConfig.getExchangeName(), rabbitConfig.getDelayQueueName(), msgBody, message -> {
            message.getMessageProperties().setDelay(3 * 1000);   // 毫秒为单位，指定此消息的延时时长
            return message;
        });
    }

    /**
     * 客服离线 队列
     *
     * @param msgBody
     */
    public void staffOfflineQueue(StaffSocketInfo staffSocketInfo) {
        //客服下线后 转发用户到其他客服
        rabbitTemplate.convertAndSend(rabbitConfig.getExchangeName(), rabbitConfig.getStaffOfflineQueueName(), staffSocketInfo, message -> {
            message.getMessageProperties().setDelay((60 * 1000));   // 毫秒为单位，指定此消息的延时时长
            return message;
        });
    }


}