package com.wecloud.im.param.rtc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 创建频道请求参数
 *
 * @author wei
 * @since 2021-04-29
 */
@Data
@ApiModel(value = "CreateRtcChannelParam")
public class CreateRtcChannelParam implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "被邀请的客户端ID", required = true)
    private String toClient;

    @ApiModelProperty(value = "客户端自定义数据", required = false)
    private String attrs;

    @ApiModelProperty(value = "类型: video或voice", required = true)
    private String type;

    @ApiModelProperty(value = "绑定的会话id,可选", required = false)
    private Long conversationId;

    @ApiModelProperty(value = "接收方展示的系统推送内容,可", required = false)
    private String push;

    @ApiModelProperty(value = "是否需要给对方发系统通知", required = true)
    private Boolean pushCall;

}
