package com.jumeirah.common.service;

import com.jumeirah.common.entity.McPlain;
import com.jumeirah.common.param.McPlainPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.param.McPlainQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 商家飞机表 服务类
 *
 * @author xxx
 * @since 2020-10-19
 */
public interface McPlainService extends BaseService<McPlain> {

    /**
     * 保存
     *
     * @param mcPlain
     * @return
     * @throws Exception
     */
    boolean saveMcPlain(McPlain mcPlain) throws Exception;

    /**
     * 修改
     *
     * @param mcPlain
     * @return
     * @throws Exception
     */
    boolean updateMcPlain(McPlain mcPlain) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteMcPlain(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    McPlainQueryVo getMcPlainById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param mcPlainPageParam
     * @return
     * @throws Exception
     */
    Paging<McPlainQueryVo> getMcPlainPageList(McPlainPageParam mcPlainPageParam) throws Exception;

}
