package com.jumeirah.common.service;

import com.jumeirah.common.entity.MerchantUser;
import com.jumeirah.common.param.MerchantLoginParam;
import com.jumeirah.common.param.MerchantUpdatePwdParam;
import com.jumeirah.common.param.MerchantUserInfoParam;
import com.jumeirah.common.param.MerchantUserPageParam;
import com.jumeirah.common.vo.LoginMerUserTokenVo;
import com.jumeirah.common.vo.MerchantUserQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 商家 服务类
 *
 * @author wei
 * @since 2020-09-28
 */
public interface MerchantUserService extends BaseService<MerchantUser> {

    /**
     * 保存
     *
     * @param merchantUser
     * @return
     * @throws Exception
     */
    boolean saveMerchantUser(MerchantUser merchantUser) throws Exception;


    /**
     * 登录
     *
     * @return
     * @throws Exception
     */
    ApiResult<LoginMerUserTokenVo> login(MerchantLoginParam merchantLoginParam) throws Exception;

    ApiResult<Boolean> updatePwd(MerchantUpdatePwdParam merchantUpdatePwdParam) throws Exception;


//        ApiResult<Boolean> register(MerchantRegisterParam merchantRegisterParam) throws Exception;


    /**
     * 修改
     *
     * @param merchantUser
     * @return
     * @throws Exception
     */
    boolean updateMerchantUser(MerchantUser merchantUser) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteMerchantUser(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    MerchantUserQueryVo getMerchantUserById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param merchantUserPageParam
     * @return
     * @throws Exception
     */
    Paging<MerchantUserQueryVo> getMerchantUserPageList(MerchantUserPageParam merchantUserPageParam) throws Exception;

    List<MerchantUserQueryVo> getMerchantUserListByMcId(Long mcId) throws Exception;


    ApiResult<List<MerchantUser>> getMerchantUserListByMcIdAndIds(MerchantUserInfoParam merchantUserInfoParam);
}
