package com.wecloud.im.sdk.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 单聊消息
 * @Author luozh
 * @Date 2022年05月05日 11:49
 * @Version 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PublishPrivateChatMessageRequest extends WebServiceRequest {
    /**
     * 发送人客户端id
     */
    private String fromUserId;

    /**
     * 指定一个或多个用户
     */
    private String toUserIds;

    /**
     * 消息类型
     */
    private String messageType;

    /**
     * 消息
     */
    private String content;

    /**
     * 指定离线推送通知中的推送内容
     */
    private String pushContent;

    /**
     * 是否包含发送用户
     */
    private Boolean includeSender;

    /**
     * 是否过滤黑名单
     */
    private Boolean includeBlacklist;

    /**
     * 是否存储此条消息
     */
    private Boolean persisted;

    /**
     * 是否为静默消息
     */
    private Boolean silent;

    /**
     * 推送拓展配置
     */
    private PushExtParam pushExt;
}
