package com.jumeirah.api.merchant.controller.order;

import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.param.McStrokePageParam;
import com.jumeirah.common.service.StrokeService;
import com.jumeirah.common.vo.McStrokeQueryVo;
import com.jumeirah.common.vo.StrokeDetailVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 行程表 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/merchant/stroke")
@Api(value = "行程API", tags = {"行程"})
public class McStrokeController extends BaseController {

    @Autowired
    private StrokeService strokeService;

    /**
     * 修改行程表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改行程表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改行程表", response = ApiResult.class)
    public ApiResult<Boolean> updateStroke(@Validated(Update.class) @RequestBody Stroke stroke) throws Exception {
        boolean flag = strokeService.updateStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 删除行程表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除行程表", response = ApiResult.class)
    public ApiResult<Boolean> deleteStroke(@PathVariable("id") Long id) throws Exception {
        boolean flag = strokeService.deleteStroke(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取行程表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "行程表详情", response = StrokeDetailVo.class)
    public ApiResult<StrokeDetailVo> getStroke(@PathVariable("id") Long id) throws Exception {
        StrokeDetailVo strokeQueryVo = strokeService.getStrokeById(id);
        return ApiResult.ok(strokeQueryVo);
    }

    /**
     * 行程表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "行程分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "行程分页列表")
    public ApiResult<Paging<McStrokeQueryVo>> getMyStrokePageList(@Validated @RequestBody McStrokePageParam mcStrokePageParam) throws Exception {
        Paging<McStrokeQueryVo> paging = strokeService.getMcStrokePageList(mcStrokePageParam);
        return ApiResult.ok(paging);
    }

}

