package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.BusinessPlain;
import com.jumeirah.common.mapper.BusinessPlainMapper;
import com.jumeirah.common.param.BusinessPlainPageParam;
import com.jumeirah.common.service.BusinessPlainService;
import com.jumeirah.common.vo.BusinessPlainQueryForAppVo;
import com.jumeirah.common.vo.BusinessPlainQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 公务机出售/托管表 服务实现类
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@Service
public class BusinessPlainServiceImpl extends BaseServiceImpl<BusinessPlainMapper, BusinessPlain> implements BusinessPlainService {

    @Autowired
    private BusinessPlainMapper businessPlainMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBusinessPlain(BusinessPlain businessPlain) throws Exception {
        return super.save(businessPlain);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateBusinessPlain(BusinessPlain businessPlain) throws Exception {
        return super.updateById(businessPlain);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteBusinessPlain(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public BusinessPlainQueryVo getBusinessPlainById(Long id) throws Exception {
        return businessPlainMapper.getBusinessPlainById(id);
    }

    @Override
    public Paging<BusinessPlainQueryVo> getBusinessPlainPageList(BusinessPlainPageParam businessPlainPageParam) throws Exception {
        Page<BusinessPlainQueryVo> page = new PageInfo<>(businessPlainPageParam, OrderItem.desc(getLambdaColumn(BusinessPlain::getCreateTime)));
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        IPage<BusinessPlainQueryVo> iPage = businessPlainMapper.getBusinessPlainPageList(page, businessPlainPageParam,jwtToken.getMcId());
        return new Paging<>(iPage);
    }


    @Override
    public Paging<BusinessPlainQueryForAppVo> getBusinessPlainPageListForApp(BusinessPlainPageParam businessPlainPageParam) throws Exception {
        Page<BusinessPlainQueryForAppVo> page = new PageInfo<>(businessPlainPageParam, OrderItem.desc("bp.create_time"));
        IPage<BusinessPlainQueryForAppVo> iPage = businessPlainMapper.getBusinessPlainPageListForApp(page, businessPlainPageParam);
        return new Paging<>(iPage);
    }


}
