/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.geekidea.springbootplus.framework.common.api;

/**
 * <p>
 * REST API 响应码
 * </p>
 *
 * @author geekidea
 * @since 2018-11-08
 */
public enum ApiCode {

    /**
     * 操作成功
     **/
    SUCCESS(200, "api.response.code.SUCCESS"),
    /**
     * 非法访问
     **/
    UNAUTHORIZED(401, "api.response.code.UNAUTHORIZED"),
    /**
     * 没有权限
     **/
    NOT_PERMISSION(403, "api.response.code.NOT_PERMISSION"),
    /**
     * 你请求的资源不存在
     **/
    NOT_FOUND(404, "api.response.code.NOT_FOUND"),
    /**
     * 操作失败
     **/
    FAIL(500, "api.response.code.FAIL"),
    /**
     * 登录失败
     **/
    LOGIN_EXCEPTION(4000, "api.response.code.LOGIN_EXCEPTION"),
    /**
     * 系统异常
     **/
    SYSTEM_EXCEPTION(5000, "api.response.code.SYSTEM_EXCEPTION"),
    /**
     * 请求参数校验异常
     **/
    PARAMETER_EXCEPTION(5001, "api.response.code.PARAMETER_EXCEPTION"),
    /**
     * 请求参数解析异常
     **/
    PARAMETER_PARSE_EXCEPTION(5002, "api.response.code.PARAMETER_PARSE_EXCEPTION"),
    /**
     * HTTP内容类型异常
     **/
    HTTP_MEDIA_TYPE_EXCEPTION(5003, "api.response.code.HTTP_MEDIA_TYPE_EXCEPTION"),
    /**
     * 系统处理异常
     **/
    SPRING_BOOT_PLUS_EXCEPTION(5100, "api.response.code.SPRING_BOOT_PLUS_EXCEPTION"),
    /**
     * 业务处理异常
     **/
    BUSINESS_EXCEPTION(5101, "api.response.code.BUSINESS_EXCEPTION"),
    /**
     * 数据库处理异常
     **/
    DAO_EXCEPTION(5102, "api.response.code.DAO_EXCEPTION"),
    /**
     * 验证码校验异常
     **/
    VERIFICATION_CODE_EXCEPTION(5103, "api.response.code.VERIFICATION_CODE_EXCEPTION"),
    /**
     * 登录授权异常
     **/
    AUTHENTICATION_EXCEPTION(5104, "api.response.code.AUTHENTICATION_EXCEPTION"),
    /**
     * 没有访问权限
     **/
    UNAUTHENTICATED_EXCEPTION(5105, "api.response.code.UNAUTHENTICATED_EXCEPTION"),
    /**
     * 没有访问权限
     **/
    UNAUTHORIZED_EXCEPTION(5106, "api.response.code.UNAUTHORIZED_EXCEPTION"),
    /**
     * JWT Token解析异常
     **/
    JWTDECODE_EXCEPTION(5107, "api.response.code.JWTDECODE_EXCEPTION"),
    /**
     * 默认的异常处理
     */
    HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION(5108, "api.response.code.HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION"),


    /**
     * 已有会话,不能重复创建会话
     */
    REPETITION_CONVERSATION(6010, "api.response.code.REPETITION_CONVERSATION"),

    /**
     * 成员不存在,不能创建会话
     */
    CLIENT_NOT_FOUNT(6011, "api.response.code.CLIENT_NOT_FOUNT"),


    /**
     * 被对方拉黑
     */
    IS_BE_BLACK(6012, "api.response.code.IS_BE_BLACK"),

    /**
     * 你把对方拉黑
     */
    IS_TO_BLACK(6013, "api.response.code.IS_TO_BLACK"),


    /**
     * 已被踢出会话
     */
    IS_BE_KICK_OUT(6014, "api.response.code.IS_BE_KICK_OUT"),


    /**
     * 已被禁言
     */
    IS_BE_MUTED(6015, "api.response.code.IS_BE_MUTED"),

    /**
     * 群聊已解散
     */
    IS_BE_DISBAND(6016, "api.response.code.IS_BE_DISBAND"),

    /**
     * 群已禁止发链接
     */
    IS_BE_FORBID_SEND_LINK(6017, "api.response.code.IS_BE_FORBID_SEND_LINK"),

    /**
     * 群已禁止发图片
     */
    IS_BE_FORBID_SEND_PIC(6018, "api.response.code.IS_BE_FORBID_SEND_PIC"),

    /**
     * 消息超出数量限制
     */
    MSG_EXCEED_QUANTITY_LIMIT(6019, "api.response.code.IS_BE_FORBID_SEND_PIC"),

    /**
     * 消息超出VIP数量限制
     */
    EXCEED_VIP_QUANTITY_LIMIT(6020, "api.response.code.IS_BE_FORBID_SEND_PIC"),

    /**
     * 已被禁言
     */
    IS_BE_BANED(6021, "api.response.code.IS_BE_BANED"),

    ;

    private final int code;
    private final String message;

    ApiCode(final int code, final String message) {
        this.code = code;
        this.message = message;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs = ApiCode.values();
        for (ApiCode ec : ecs) {
            if (ec.getCode() == code) {
                return ec;
            }
        }
        return SUCCESS;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
