package io.geekidea.springbootplus.test;

import com.wecloud.im.router.RouterSendService;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.utils.JsonUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.router.address.Address;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * dubbo指定ip调用测试类
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class DubboRpcTest {

    /*
     * 解决log日志依赖冲突问题
     */
    static {
        System.setProperty("nacos.logging.default.config.enabled", "false");
    }

    /*
     * 指定ip调用,router=address;
     * injvm = false要设置成false,否则会调用到本地提供者
     */
    @DubboReference(injvm = false, interfaceClass = RouterSendService.class, parameters = {"router", "address"})
    private RouterSendService routerSendService;


    @Test
    public void test() {
        int i = 0;

        WsResponse wsResponse = new WsResponse();
        wsResponse.setCmd(i);
        wsResponse.setCode(200);
        wsResponse.setMsg("i=" + i);
        wsResponse.setData("hihi");
        wsResponse.setReqId("123");

        String msgJson = JsonUtils.encodeJson(wsResponse);

        //  根据provider的ip,port创建Address实例
        Address address = new Address("192.168.1.51", 20881);
        RpcContext.getContext().setObjectAttachment("address", address);
        routerSendService.sendMsgRemote(123L, 1, msgJson);
    }


}
