package com.wecloud.imserver.client.model.enums;

/**
 * @Author wenzhida
 * @Date 2022/1/26 16:58
 * @Description 设备是否想接收到推送提醒美剧
 */
public enum DeviceTypeEnum {

    /**
     * 1 - ios
     */
    IOS(1, "ios"),

    /**
     * 2 - android
     */
    ANDROID(2, "android");

    DeviceTypeEnum(int code, String value) {
        this.code = code;
        this.value = value;
    }

    private int code;
    private String value;

    /**
     * 获取对应的中文名称
     *
     * @param code 枚举值
     * @return 枚举对应的中文名称
     */
    public static String getValue(Integer code) {
        if (code == null) {
            return null;
        }
        for (DeviceTypeEnum c : DeviceTypeEnum.values()) {
            if (c.code == code) {
                return c.value;
            }
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public int getCode() {
        return this.code;
    }
}
