package com.wecloud.rtc.service.impl;

import com.wecloud.im.ws.enums.WsResponseCmdEnum;
import com.wecloud.im.ws.enums.WsRtcResponseSubCmdEnum;
import com.wecloud.im.ws.model.WsResponseModel;
import com.wecloud.im.ws.sender.ChannelSender;
import com.wecloud.rtc.entity.response.RtcCallResponse;
import com.wecloud.rtc.entity.response.RtcCandidateForwardResponse;
import com.wecloud.rtc.entity.response.RtcClientJoinResponse;
import com.wecloud.rtc.entity.response.RtcClientLeaveResponse;
import com.wecloud.rtc.entity.response.RtcClientRejectResponse;
import com.wecloud.rtc.entity.response.RtcResponseBase;
import com.wecloud.rtc.entity.response.RtcSdpForwardResponse;
import com.wecloud.rtc.service.WsRtcWrite;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WsRtcWriteImpl implements WsRtcWrite {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void rtcCall(RtcCallResponse rtcCallResponse, String toAppKey, String toClientId) {

        RtcResponseBase<RtcCallResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.RTC_CALL.getCmdCode());
        rtcResponseBase.setSubData(rtcCallResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcCallResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);

    }

    @Override
    public void clientJoin(RtcClientJoinResponse rtcClientJoinResponse, String toAppKey, String toClientId) {

        RtcResponseBase<RtcClientJoinResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_JOIN.getCmdCode());
        rtcResponseBase.setSubData(rtcClientJoinResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcClientJoinResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);


    }

    @Override
    public void clientLeave(RtcClientLeaveResponse rtcClientLeaveResponse, String toAppKey, String toClientId) {


        RtcResponseBase<RtcClientLeaveResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_LEAVE.getCmdCode());
        rtcResponseBase.setSubData(rtcClientLeaveResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcClientLeaveResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);

    }

    @Override
    public void clientReject(RtcClientRejectResponse rtcClientRejectResponse, String toAppKey, String toClientId) {

        RtcResponseBase<RtcClientRejectResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.CLIENT_REJECT.getCmdCode());
        rtcResponseBase.setSubData(rtcClientRejectResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcClientRejectResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);
    }

    @Override
    public void sdpForward(RtcSdpForwardResponse rtcSdpForwardResponse, String toAppKey, String toClientId) {

        RtcResponseBase<RtcSdpForwardResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.SDP_FORWARD.getCmdCode());
        rtcResponseBase.setSubData(rtcSdpForwardResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcSdpForwardResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);
    }

    @Override
    public void candidateForward(RtcCandidateForwardResponse rtcCandidateForwardResponse, String toAppKey, String toClientId) {

        RtcResponseBase<RtcCandidateForwardResponse> rtcResponseBase = new RtcResponseBase<>();
        rtcResponseBase.setSubCmd(WsRtcResponseSubCmdEnum.CANDIDATE_FORWARD.getCmdCode());
        rtcResponseBase.setSubData(rtcCandidateForwardResponse);
//        rtcResponseBase.setAttrs(rtcCallResponse.get);

        //  向接收方推送
        WsResponseModel<RtcResponseBase<RtcCandidateForwardResponse>> responseModel = new WsResponseModel<>();
        responseModel.setCmd(WsResponseCmdEnum.SINGLE_RTC_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(rtcResponseBase);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toAppKey, toClientId);
    }


}
