package com.wecloud.im.controller;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.param.GetClientInfoParam;
import com.wecloud.im.param.GetOnlineStatusParam;
import com.wecloud.im.param.add.ImClientDeviceInfoAdd;
import com.wecloud.im.param.add.ImClientHeadPortraitAdd;
import com.wecloud.im.param.add.ImClientHeadPortraitAndNicknameUpdate;
import com.wecloud.im.param.add.ImClientNicknameAdd;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.vo.GetInfoListVo;
import com.wecloud.im.vo.ImOnlineStatusVo;
import com.wecloud.im.ws.cache.UserStateCacheManager;
import com.wecloud.im.ws.manager.ChannelManager;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.geekidea.springbootplus.framework.shiro.util.JwtUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 终端表 控制器
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@RestController
@RequestMapping("/imClient")
@Api(value = "终端", tags = {"终端"})
public class ImClientController extends BaseController {

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private UserStateCacheManager userStateCacheManager;

    @Autowired
    private ImApplicationService imApplicationService;


    @PostMapping("/infoList")
    @ApiOperation(value = "根据id获取Client的头像昵称")
    public ApiResult<List<GetInfoListVo>> getInfoList(@Validated(Add.class) @RequestBody GetClientInfoParam getClientInfoParam) throws Exception {
        return imClientService.getInfoList(getClientInfoParam);
    }


    /**
     * 添加或修改推送设备信息
     */
    @PostMapping("/addDeviceInfo")
    @ApiOperation(value = "添加或修改推送设备信息(每次请求都会覆盖之前的数据)")
    public ApiResult<Boolean> addDeviceInfo(@Validated(Add.class) @RequestBody ImClientDeviceInfoAdd imClientDevice) throws Exception {
        boolean flag = imClientService.updateDeviceInfo(imClientDevice);
        return ApiResult.result(flag);
    }


    @PostMapping("/updateHeadAndNickname")
    @ApiOperation(value = "添加或修改头像和昵称")
    public ApiResult<Boolean> updateHeadAndNickname(@Validated(Add.class) @RequestBody ImClientHeadPortraitAndNicknameUpdate imClientHeadPortraitAndNicknameUpdate) throws Exception {
        boolean flag = imClientService.updateHeadAndNickname(imClientHeadPortraitAndNicknameUpdate);
        return ApiResult.result(flag);
    }


    @PostMapping("/updateHeadPortrait")
    @ApiOperation(value = "添加或修改头像")
    public ApiResult<Boolean> updateHeadPortrait(@Validated(Add.class) @RequestBody ImClientHeadPortraitAdd imClientHeadPortraitAdd) throws Exception {
        boolean flag = imClientService.updateHeadPortrait(imClientHeadPortraitAdd);
        return ApiResult.result(flag);
    }

    @PostMapping("/updateNickname")
    @ApiOperation(value = "添加或修改主昵称")
    public ApiResult<Boolean> updateNickname(@Validated(Add.class) @RequestBody ImClientNicknameAdd imClientNicknameAdd) throws Exception {
        boolean flag = imClientService.updateNickname(imClientNicknameAdd);
        return ApiResult.result(flag);
    }


    /**
     * 退出登陆
     *
     * @return
     * @throws Exception
     */
    @PostMapping("/logout")
    @ApiOperation(value = "退出登陆 清除推送token等")
    public ApiResult<Boolean> logout() throws Exception {
        boolean flag = imClientService.logout();
        return ApiResult.result(flag);
    }

    /**
     * 获取用户在线状态(批量)
     *
     * @return true:在线, false 不在线
     */
    @PostMapping("/onlineStatus")
    @ApiOperation(value = "获取用户在线状态(批量)")
    ApiResult<List<ImOnlineStatusVo>> getOnlineStatus(@RequestBody GetOnlineStatusParam getOnlineStatusParam) {
        // shiro线程中获取当前token
        JwtToken curentJwtToken = JwtUtil.getCurentJwtToken();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getOneByAppKey(curentJwtToken.getAppKey());
        ArrayList<ImOnlineStatusVo> imOnlineStatusVos = new ArrayList<ImOnlineStatusVo>();
        for (String clientId : getOnlineStatusParam.getClientIds()) {

            ImOnlineStatusVo imOnlineStatusVo = new ImOnlineStatusVo();
            // todo 需要改成批量
            imOnlineStatusVo.setStatus(userStateCacheManager.isOnline(imApplication.getAppKey(), clientId));
            imOnlineStatusVo.setClientId(clientId);
            imOnlineStatusVos.add(imOnlineStatusVo);
        }
        return ApiResult.ok(imOnlineStatusVos);
    }
//
//    /**
//     * 获取用户在线状态(批量)
//     *
//     * @return true:在线, false 不在线
//     */
//    @PostMapping("/getOnlineStatus")
//    @OperationLog(name = "获取用户在线状态", type = OperationLogType.ADD)
//    @ApiOperation(value = "获取用户在线状态")
//    ApiResult<ImOnlineStatusVo> getOnlinesStatus(String clientId) {
//        // shiro线程中获取当前token
//        JwtToken curentJwtToken = JwtUtil.getCurentJwtToken();
//
//        //  根据appKey查询appid
//        ImApplication imApplication = imApplicationService.getOneByAppKey(curentJwtToken.getAppKey());
//
//        boolean onlineStatus = mangerChannelService.getOnlineStatus(imApplication.getAppKey(), clientId);
//        ImOnlineStatusVo imOnlineStatusVo = new ImOnlineStatusVo();
//        imOnlineStatusVo.setStatus(onlineStatus);
//        return ApiResult.ok(imOnlineStatusVo);
//    }

//    /**
//     * 添加终端表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加终端表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加终端表")
//    public ApiResult<Boolean> addImClient(@Validated(Add.class) @RequestBody ImClient imClient) throws Exception {
//        boolean flag = imClientService.saveImClient(imClient);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改终端表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改终端表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改终端表")
//    public ApiResult<Boolean> updateImClient(@Validated(Update.class) @RequestBody ImClient imClient) throws Exception {
//        boolean flag = imClientService.updateImClient(imClient);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除终端表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除终端表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除终端表")
//    public ApiResult<Boolean> deleteImClient(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imClientService.deleteImClient(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取终端表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "终端表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "终端表详情")
//    public ApiResult<ImClientQueryVo> getImClient(@PathVariable("id") Long id) throws Exception {
//        ImClientQueryVo imClientQueryVo = imClientService.getImClientById(id);
//        return ApiResult.ok(imClientQueryVo);
//    }
//
//    /**
//     * 终端表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "终端表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "终端表分页列表")
//    public ApiResult<Paging<ImClientQueryVo>> getImClientPageList(@Validated @RequestBody ImClientPageParam imClientPageParam) throws Exception {
//        Paging<ImClientQueryVo> paging = imClientService.getImClientPageList(imClientPageParam);
//        return ApiResult.ok(paging);
//    }

}

