package com.wecloud.multimeet.service.impl;

import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.InviteToMultiMeetParam;
import com.wecloud.im.param.RejectToMultiMeetParam;
import com.wecloud.im.param.rtc.CreateRtcChannelResult;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.ws.cache.UserStateCacheManager;
import com.wecloud.multimeet.entity.response.MultiMeetInviteResponse;
import com.wecloud.multimeet.entity.response.MultiMeetRejectResponse;
import com.wecloud.multimeet.service.MultiMeetService;
import com.wecloud.multimeet.service.WsMultiMeetWrite;
import com.wecloud.utils.SnowflakeUtil;
import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author wenzhida
 * @Date 2022/3/7 18:43
 * @Description 多人音视频接口实现
 */
@Slf4j
@Service
public class MultiMeetServiceImpl implements MultiMeetService {

    @Autowired
    private WsMultiMeetWrite wsMultiMeetWrite;

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private UserStateCacheManager userStateCacheManager;

    @Override
    public void invite(InviteToMultiMeetParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        //  判断发起方必须在线
        boolean onlineStatus = userStateCacheManager.isOnline(currentClient.getId());
        if (!onlineStatus) {
            log.info("发起方必须在线" + currentClient.getFkAppid() + currentClient.getClientId());
            throw new BusinessException("发起方必须在线");
        }
        for (String toClient : param.getToClients()) {
            ImClient receiver = imClientService.getCacheImClient(currentClient.getFkAppid(), toClient);
            if (receiver == null) {
                log.info("查无接收人信息 {}", toClient);
                continue;
            }
            // ws向接收方发送通知
            MultiMeetInviteResponse multiMeetInviteResponse = new MultiMeetInviteResponse();
            multiMeetInviteResponse.setConversationId(param.getConversationId());
            multiMeetInviteResponse.setRoomId(param.getRoomId());
            multiMeetInviteResponse.setClientId(currentClient.getClientId());
            multiMeetInviteResponse.setTimestamp(System.currentTimeMillis());

            wsMultiMeetWrite.invite(multiMeetInviteResponse, receiver.getId());

            // TODO 待开发 下发安卓和ios系统推送
        }
    }

    @Override
    public void reject(RejectToMultiMeetParam param) {
        ImClient currentClient = imClientService.getCurrentClient();
        // ws向接收方发送通知
        MultiMeetRejectResponse multiMeetRejectResponse = new MultiMeetRejectResponse();
        multiMeetRejectResponse.setConversationId(param.getConversationId());
        multiMeetRejectResponse.setRoomId(param.getRoomId());

        multiMeetRejectResponse.setClientId(currentClient.getClientId());
        multiMeetRejectResponse.setTimestamp(System.currentTimeMillis());
        ImClient receiver = imClientService.getCacheImClient(currentClient.getFkAppid(), param.getInviterClientId());
        if (receiver == null) {
            log.info("查无接收人信息 {}", param.getInviterClientId());
            throw new BusinessException("查无发起会议人信息");
        }
        wsMultiMeetWrite.reject(multiMeetRejectResponse, receiver.getId());
    }

}
