package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.param.ImApplicationPageParam;
import com.wecloud.im.param.ImApplicationQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 第三方应用表 Mapper 接口
 *
 * @author wei
 * @since 2021-04-27
 */
@Repository
public interface ImApplicationMapper extends BaseMapper<ImApplication> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImApplicationQueryVo getImApplicationById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imApplicationPageParam
     * @return
     */
    IPage<ImApplicationQueryVo> getImApplicationPageList(@Param("page") Page page, @Param("param") ImApplicationPageParam imApplicationPageParam);

}
