package io.geekidea.springbootplus.framework.config.il8n;

import lombok.Getter;
import lombok.ToString;
import org.springframework.util.StringUtils;

/**
 * 语言枚举类
 */
@Getter
@ToString
public enum LanguageEnum {

    /**
     * 美式英文
     */
    LANGUAGE_EN_US("en_US"),

//    /**
//     * 柬埔寨 高棉语
//     */
//    LANGUAGE_KH("kh"),

    /**
     * 简体中文
     */
    LANGUAGE_ZH_CN("zh_CN");

    private final String language;

    LanguageEnum(String language) {
        this.language = language;
    }


    /**
     * 获取指定语言类型(如果没有对应的语言类型,则返回中文)
     *
     * @param language 语言类型
     * @return
     */
    public static String getLanguageType(String language) {
        // 设置默认为中文
        if (StringUtils.isEmpty(language)) {
            return LANGUAGE_ZH_CN.language;
        }
        for (LanguageEnum languageEnum : LanguageEnum.values()) {
            if (languageEnum.language.equalsIgnoreCase(language)) {
                return languageEnum.language;
            }
        }
        return LANGUAGE_ZH_CN.language;
    }

}
