package com.wecloud.im.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

/**
 * 会话表
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImConversation对象")
public class ImConversation extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("对话中最后一条消息的发送或接收时间")
    private Date lastMessage;

    @ApiModelProperty("群成员数量")
    private Integer memberCount;

    /**
     * 会话属性
     * @see com.wecloud.im.sdk.enums.ChatTypeEnum
     */
    @ApiModelProperty("会话属性，1：单聊，2：普通群，3：万人群,4：聊天室")
    private Integer chatType;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @NotNull(message = "创建者客户端id不能为空")
    @ApiModelProperty("创建者客户端id")
    private Long creator;

    @ApiModelProperty("可选	 对话的名字，可为群组命名。")
    private String name;

    @ApiModelProperty("群头像")
    private String headPortrait;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private String attributes;

    @ApiModelProperty("可选	对话类型标志，是否是系统对话，后面会说明。")
    private Boolean systemFlag;

    /**
     * 禁言开关
     * @see com.wecloud.im.sdk.enums.MutedEnum
     */
    @ApiModelProperty("禁言开关 1-未禁言 2-禁言")
    private Integer muted;

    @TableField("is_forbid_add_friend")
    @ApiModelProperty("禁止互加好友")
    private Boolean forbidAddFriend;

    @TableField("is_forbid_send_pic")
    @ApiModelProperty("禁止发图片")
    private Boolean forbidSendPic;

    @TableField("is_forbid_send_link")
    @ApiModelProperty("禁止发链接")
    private Boolean forbidSendLink;

    @ApiModelProperty("是否为加密聊天 0-否 1-是")
    private Integer isEncrypt;

}
