package com.wecloud.im.core.validator.constraints;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.wecloud.im.core.common.enums.BaseEnum;
import com.wecloud.im.core.validator.EnumTypeValidator;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 枚举类型注解
 *
 * @author geekidea
 * @date 2018-11-08
 */
@Documented
@Constraint(validatedBy = {EnumTypeValidator.class})
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
public @interface EnumType {
    String message() default "请输入正确的类型值";

    Class<? extends BaseEnum> type();

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
