package com.wecloud.im.core.util;

import com.wecloud.im.core.bean.RequestDetail;

/**
 * 记录请求详情信息到当前线程中，可在任何地方获取
 *
 * @author geekidea
 * @date 2020/3/26
 **/
public class RequestDetailThreadLocal {

    private static final ThreadLocal<RequestDetail> THREAD_LOCAL = new ThreadLocal<>();

    /**
     * 从当前线程中获取请求信息
     */
    public static RequestDetail getRequestDetail() {
        return THREAD_LOCAL.get();
    }

    /**
     * 设置请求信息到当前线程中
     *
     * @param requestDetail
     */
    public static void setRequestDetail(RequestDetail requestDetail) {
        THREAD_LOCAL.set(requestDetail);
    }

    /**
     * 销毁
     */
    public static void remove() {
        THREAD_LOCAL.remove();
    }

}
