package com.wecloud.im.biz.module.message.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.wecloud.im.biz.module.message.controller.param.ChatContentVo;
import com.wecloud.im.biz.module.message.controller.param.GetReadersParam;
import com.wecloud.im.biz.module.message.controller.param.GroupChatMessageParam;
import com.wecloud.im.biz.module.message.controller.param.GroupChatStatusMessageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientSimpleDto;
import com.wecloud.im.biz.module.message.controller.param.ImHistoryMessagePageParam;
import com.wecloud.im.biz.module.message.controller.param.MsgDeleteParam;
import com.wecloud.im.biz.module.message.controller.param.PrivateChatMessageParam;
import com.wecloud.im.biz.module.message.controller.param.PrivateChatStatusMessageParam;
import com.wecloud.im.biz.module.message.controller.param.SingleUserNotificationParam;
import com.wecloud.im.biz.module.message.controller.param.add.ImMsgRecall;
import com.wecloud.im.biz.module.message.controller.param.add.ImMsgSendToOnlineClient;
import com.wecloud.im.biz.module.message.controller.param.add.ImMsgUpdate;
import com.wecloud.im.biz.module.message.controller.vo.ImMessageOfflineListVo;
import com.wecloud.im.biz.module.message.controller.vo.OfflineMsgDto;
import com.wecloud.im.biz.module.message.controller.vo.ReaderList;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.entity.ImMessage;
import com.wecloud.im.core.common.api.ApiResult;
import com.wecloud.im.core.common.service.BaseService;
import com.wecloud.im.core.pagination.Paging;
import com.wecloud.im.server.model.request.ReceiveDataVO;
import com.wecloud.im.server.model.request.ReceiveVO;

/**
 * 消息存储表 服务类
 *
 * @author wei
 * @since 2021-04-29
 */
public interface ImMessageService extends BaseService<ImMessage> {


    /**
     * 下发透传消息
     *
     * @param imMsgSendToOnlineClient
     * @return
     */
    ApiResult<Boolean> restApiImMessageSend(ImMsgSendToOnlineClient imMsgSendToOnlineClient, ImApplication imApplication);


    ImMessage saveImMessage(ImApplication imApplication, ImClient imClientSender, long messageId, ReceiveVO receiveVO, ReceiveDataVO sysParam);


    @Transactional(rollbackFor = Exception.class)
    ImMessage saveImMessage(ImClientSimpleDto client, long messageId, ChatContentVo data);

    /**
     * 消息撤回
     * @param imMsgRecall
     * @param request
     * @return
     */
    Boolean withdrawMsg(ImMsgRecall imMsgRecall);

    /**
     * 删除消息
     * @param param
     * @return
     */
    Boolean deleteMsg(MsgDeleteParam param);

    /**
     * 修改消息体
     *
     * @param imMsgUpdate
     * @return
     */
    Boolean updateMsgById(ImMsgUpdate imMsgUpdate);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationId(ImHistoryMessagePageParam param);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationIdNew(ImHistoryMessagePageParam param);

    /**
     * 查询用户所有离线消息
     *
     * @return
     * @throws Exception
     */
    List<ImMessageOfflineListVo> getOfflineList() throws Exception;

    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(Long clientId, Long conversationId);


    /**
     * 查询会话的最后一条消息
     *
     * @param conversationId
     * @return
     */
    OfflineMsgDto getLastMsgByConversationId(Long conversationId, Long currentFkClientId);

    /**
     * 查询会话接收的最后一条消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    OfflineMsgDto getReceivedLastMsgByConversationId(Long clientId, Long conversationId);

    /**
     * 保存
     *
     * @param imMessage
     * @return
     * @throws Exception
     */
    boolean saveImMessage(ImMessage imMessage) throws Exception;

    /**
     * 获取读取人员
     * @param param
     * @return
     */
    ReaderList getReaders(GetReadersParam param);

    /**
     * 发送群聊消息
     * @param param
     * @return
     */
    Boolean groupMessagePublish(GroupChatMessageParam param);

    /**
     * 发送群聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 02:32:58
     * @param param
     * @Return
     */
    Boolean groupStatusMessagePublish(GroupChatStatusMessageParam param);

    /**
     * 发送单聊消息
     * @Author luozh
     * @Date 2022年05月05日 02:33:26
     * @param param
     * @Return
     */
    Boolean privateMessagePublish(PrivateChatMessageParam param);

    /**
     * 发送单聊状态消息
     * @Author luozh
     * @Date 2022年05月05日 02:33:56
     * @param param
     * @Return
     */
    Boolean privateStatusMessagePublish(PrivateChatStatusMessageParam param);

    /**
     * 单个用户通知-普通消息
     * @Author luozh
     * @Date 2022年05月25日 10:42:31
     * @param param
     * @Return
     */
    Boolean singleUserNotification(SingleUserNotificationParam param);
}
