package com.wecloud.im.biz.module.message.controller.param.add;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import com.wecloud.im.biz.enums.DeviceTypeEnum;
import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * 添加或修改推送设备信息
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加或修改推送设备信息")
public class ClientDeviceUpdateParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("设备不想收到推送提醒, 1想, 0不想")
    private Integer valid;

    /**
     * 设备类型
     * @see DeviceTypeEnum
     */
    @ApiModelProperty("设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac")
    private Integer deviceType;

    @ApiModelProperty("设备推送token")
    private String deviceToken;

    @ApiModelProperty("唯一设备id")
    private String uniqueDeviceId;
}
