package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

import com.wecloud.im.biz.enums.MutedEnum;
import com.wecloud.im.core.common.entity.BaseEntity;

/**
 * @Author wenzhida
 * @Date 2022/2/17 15:58
 * @Description 群禁言入参
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "群禁言入参")
public class MutedGroupParam extends BaseEntity {

    private static final long serialVersionUID = -6974569111928946842L;

    @NotNull
    @ApiModelProperty("会话id")
    private Long conversationId;

    /**
     * 禁言类型
     * @see MutedEnum
     */
    @NotNull
    @ApiModelProperty("禁言类型 1-取消禁言 2-禁言")
    private Integer mutedType;

}
