package com.wecloud.im.biz.enums;

import com.wecloud.im.core.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/3/11 16:24
 * @Description 消息是否已读枚举
 */
public enum ReadMsgStatusEnum implements BaseEnum {

    /**
     * 0 - 未读
     */
    UNREAD(0, "未读"),

    /**
     * 1 - 已读
     */
    READ(1, "已读");

    ReadMsgStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
