package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 公务机出售/托管表 查询结果对象
 * </pre>
 *
 * @author giao
 * @date 2020-10-14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "BusinessPlainQueryVo对象")
public class BusinessPlainQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("商家ID")
    private Long mcId;

    @ApiModelProperty("业务类型，0-出售，1-托管")
    private Integer businessType;

    @ApiModelProperty("图片url")
    private String imgUrl;

    @ApiModelProperty("机型介绍")
    private String introduction;

    @ApiModelProperty("销售员姓名")
    private String name;

    @ApiModelProperty("销售联系电话")
    private String phone;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间（时间戳）")
    private Date createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Date updateTime;
}