package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ImMessagePageParam;
import com.wecloud.im.param.ImMessageQueryVo;
import com.wecloud.im.vo.OfflineMsgDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 消息存储表 Mapper 接口
 *
 * @author wei
 * @since 2021-04-29
 */
@Repository
public interface ImMessageMapper extends BaseMapper<ImMessage> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImMessageQueryVo getImMessageById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imMessagePageParam
     * @return
     */
    IPage<ImMessageQueryVo> getImMessagePageList(@Param("page") Page page, @Param("param") ImMessagePageParam imMessagePageParam);


    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(@Param("clientId") Long clientId, @Param("conversationId") Long conversationId);
}
